/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityDeployFailureReason;
import com.hubspot.singularity.SingularityTaskId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;

@Schema(description="Details about a failed deploy")
public class SingularityDeployFailure {
    private final SingularityDeployFailureReason reason;
    private final Optional<SingularityTaskId> taskId;
    private final Optional<String> message;

    public SingularityDeployFailure(SingularityDeployFailureReason reason) {
        this(reason, Optional.absent(), Optional.absent());
    }

    public static List<SingularityDeployFailure> lbUpdateFailed() {
        return Collections.singletonList(new SingularityDeployFailure(SingularityDeployFailureReason.LOAD_BALANCER_UPDATE_FAILED));
    }

    public static List<SingularityDeployFailure> failedToSave() {
        return Collections.singletonList(new SingularityDeployFailure(SingularityDeployFailureReason.FAILED_TO_SAVE_DEPLOY_STATE));
    }

    public static List<SingularityDeployFailure> deployRemoved() {
        return Collections.singletonList(new SingularityDeployFailure(SingularityDeployFailureReason.PENDING_DEPLOY_REMOVED));
    }

    @JsonCreator
    public SingularityDeployFailure(@JsonProperty(value="reason") SingularityDeployFailureReason reason, @JsonProperty(value="taskId") Optional<SingularityTaskId> taskId, @JsonProperty(value="message") Optional<String> message) {
        this.reason = reason;
        this.taskId = taskId;
        this.message = message;
    }

    @Schema(description="The enum reason for deploy failure")
    public SingularityDeployFailureReason getReason() {
        return this.reason;
    }

    @Schema(description="The task id associated with this deploy failure reason. Failure is not task-specific if not present", nullable=true)
    public Optional<SingularityTaskId> getTaskId() {
        return this.taskId;
    }

    @Schema(description="Extra details associated with the deploy failure", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    public String toString() {
        return "SingularityDeployFailure{reason=" + (Object)((Object)this.reason) + ", taskId=" + this.taskId + ", message=" + this.message + '}';
    }
}

