/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.deploy.HealthcheckOptions;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityContainerInfo;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.mesos.SingularityMesosTaskLabel;
import com.hubspot.singularity.HealthcheckProtocol;
import com.hubspot.singularity.JsonHelpers;
import com.hubspot.singularity.SingularityDeployBuilder;
import com.hubspot.singularity.SingularityS3UploaderFile;
import com.hubspot.singularity.api.SingularityRunNowRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Schema(description="A set of instructions for launching tasks associated with a request")
public class SingularityDeploy {
    private final String requestId;
    private final String id;
    private final Optional<String> version;
    private final Optional<Long> timestamp;
    private final Optional<Map<String, String>> metadata;
    private final Optional<SingularityContainerInfo> containerInfo;
    private final Optional<String> customExecutorCmd;
    private final Optional<String> customExecutorId;
    private final Optional<String> customExecutorSource;
    private final Optional<Resources> customExecutorResources;
    private final Optional<Resources> resources;
    private final Optional<String> command;
    private final Optional<List<String>> arguments;
    private final Optional<Map<String, String>> env;
    private final Optional<List<SingularityMesosArtifact>> uris;
    private final Optional<ExecutorData> executorData;
    @Deprecated
    private final Optional<Map<String, String>> labels;
    private final Optional<List<SingularityMesosTaskLabel>> mesosLabels;
    private final Optional<Map<Integer, Map<String, String>>> taskLabels;
    private final Optional<Map<Integer, List<SingularityMesosTaskLabel>>> mesosTaskLabels;
    private final Optional<Map<Integer, Map<String, String>>> taskEnv;
    private final Optional<SingularityRunNowRequest> runImmediatelyRequest;
    @Deprecated
    private final Optional<String> healthcheckUri;
    @Deprecated
    private final Optional<Long> healthcheckIntervalSeconds;
    @Deprecated
    private final Optional<Long> healthcheckTimeoutSeconds;
    @Deprecated
    private final Optional<Integer> healthcheckPortIndex;
    @Deprecated
    private final Optional<HealthcheckProtocol> healthcheckProtocol;
    @Deprecated
    private final Optional<Integer> healthcheckMaxRetries;
    @Deprecated
    private final Optional<Long> healthcheckMaxTotalTimeoutSeconds;
    private final Optional<HealthcheckOptions> healthcheck;
    private final Optional<Boolean> skipHealthchecksOnDeploy;
    private final Optional<Long> deployHealthTimeoutSeconds;
    private final Optional<Long> considerHealthyAfterRunningForSeconds;
    private final Optional<String> serviceBasePath;
    private final Optional<Set<String>> loadBalancerGroups;
    private final Optional<Integer> loadBalancerPortIndex;
    private final Optional<Map<String, Object>> loadBalancerOptions;
    private final Optional<Set<String>> loadBalancerDomains;
    private final Optional<List<String>> loadBalancerAdditionalRoutes;
    private final Optional<String> loadBalancerTemplate;
    private final Optional<String> loadBalancerServiceIdOverride;
    private final Optional<String> loadBalancerUpstreamGroup;
    private final Optional<Integer> deployInstanceCountPerStep;
    private final Optional<Integer> deployStepWaitTimeMs;
    private final Optional<Boolean> autoAdvanceDeploySteps;
    private final Optional<Integer> maxTaskRetries;
    private final Optional<Boolean> shell;
    private final Optional<String> user;
    private final List<SingularityS3UploaderFile> s3UploaderAdditionalFiles;

    public static SingularityDeployBuilder newBuilder(String requestId, String id) {
        return new SingularityDeployBuilder(requestId, id);
    }

    @JsonCreator
    public SingularityDeploy(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="id") String id, @JsonProperty(value="command") Optional<String> command, @JsonProperty(value="arguments") Optional<List<String>> arguments, @JsonProperty(value="containerInfo") Optional<SingularityContainerInfo> containerInfo, @JsonProperty(value="customExecutorCmd") Optional<String> customExecutorCmd, @JsonProperty(value="customExecutorId") Optional<String> customExecutorId, @JsonProperty(value="customExecutorSource") Optional<String> customExecutorSource, @JsonProperty(value="customExecutorResources") Optional<Resources> customExecutorResources, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="env") Optional<Map<String, String>> env, @JsonProperty(value="taskEnv") Optional<Map<Integer, Map<String, String>>> taskEnv, @JsonProperty(value="runImmediately") Optional<SingularityRunNowRequest> runImmediatelyRequest, @JsonProperty(value="uris") Optional<List<SingularityMesosArtifact>> uris, @JsonProperty(value="metadata") Optional<Map<String, String>> metadata, @JsonProperty(value="executorData") Optional<ExecutorData> executorData, @JsonProperty(value="version") Optional<String> version, @JsonProperty(value="timestamp") Optional<Long> timestamp, @JsonProperty(value="labels") Optional<Map<String, String>> labels, @JsonProperty(value="mesosLabels") Optional<List<SingularityMesosTaskLabel>> mesosLabels, @JsonProperty(value="taskLabels") Optional<Map<Integer, Map<String, String>>> taskLabels, @JsonProperty(value="mesosTaskLabels") Optional<Map<Integer, List<SingularityMesosTaskLabel>>> mesosTaskLabels, @JsonProperty(value="deployHealthTimeoutSeconds") Optional<Long> deployHealthTimeoutSeconds, @JsonProperty(value="healthcheckUri") Optional<String> healthcheckUri, @JsonProperty(value="healthcheckIntervalSeconds") Optional<Long> healthcheckIntervalSeconds, @JsonProperty(value="healthcheckTimeoutSeconds") Optional<Long> healthcheckTimeoutSeconds, @JsonProperty(value="healthcheckPortIndex") Optional<Integer> healthcheckPortIndex, @JsonProperty(value="healthcheckMaxRetries") Optional<Integer> healthcheckMaxRetries, @JsonProperty(value="healthcheckMaxTotalTimeoutSeconds") Optional<Long> healthcheckMaxTotalTimeoutSeconds, @JsonProperty(value="healthcheck") Optional<HealthcheckOptions> healthcheck, @JsonProperty(value="serviceBasePath") Optional<String> serviceBasePath, @JsonProperty(value="loadBalancerGroups") Optional<Set<String>> loadBalancerGroups, @JsonProperty(value="loadBalancerPortIndex") Optional<Integer> loadBalancerPortIndex, @JsonProperty(value="considerHealthyAfterRunningForSeconds") Optional<Long> considerHealthyAfterRunningForSeconds, @JsonProperty(value="loadBalancerOptions") Optional<Map<String, Object>> loadBalancerOptions, @JsonProperty(value="loadBalancerDomains") Optional<Set<String>> loadBalancerDomains, @JsonProperty(value="loadBalancerAdditionalRoutes") Optional<List<String>> loadBalancerAdditionalRoutes, @JsonProperty(value="loadBalancerTemplate") Optional<String> loadBalancerTemplate, @JsonProperty(value="loadBalancerServiceIdOverride") Optional<String> loadBalancerServiceIdOverride, @JsonProperty(value="loadBalancerUpstreamGroup") Optional<String> loadBalancerUpstreamGroup, @JsonProperty(value="skipHealthchecksOnDeploy") Optional<Boolean> skipHealthchecksOnDeploy, @JsonProperty(value="healthCheckProtocol") Optional<HealthcheckProtocol> healthcheckProtocol, @JsonProperty(value="deployInstanceCountPerStep") Optional<Integer> deployInstanceCountPerStep, @JsonProperty(value="deployStepWaitTimeMs") Optional<Integer> deployStepWaitTimeMs, @JsonProperty(value="autoAdvanceDeploySteps") Optional<Boolean> autoAdvanceDeploySteps, @JsonProperty(value="maxTaskRetries") Optional<Integer> maxTaskRetries, @JsonProperty(value="shell") Optional<Boolean> shell, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="s3UploaderAdditionalFiles") List<SingularityS3UploaderFile> s3UploaderAdditionalFiles) {
        this.requestId = requestId;
        this.command = command;
        this.arguments = arguments;
        this.resources = resources;
        this.containerInfo = containerInfo;
        this.customExecutorCmd = customExecutorCmd;
        this.customExecutorId = customExecutorId;
        this.customExecutorSource = customExecutorSource;
        this.customExecutorResources = customExecutorResources;
        this.metadata = metadata;
        this.version = version;
        this.id = id;
        this.timestamp = timestamp;
        this.env = env;
        this.taskEnv = taskEnv;
        this.uris = uris;
        this.executorData = executorData;
        this.runImmediatelyRequest = runImmediatelyRequest;
        this.labels = labels;
        this.mesosLabels = mesosLabels.or(labels.isPresent() ? Optional.of(SingularityMesosTaskLabel.labelsFromMap(labels.get())) : Optional.absent());
        this.taskLabels = taskLabels;
        this.mesosTaskLabels = mesosTaskLabels.or(taskLabels.isPresent() ? Optional.of(SingularityDeploy.parseMesosTaskLabelsFromMap(taskLabels.get())) : Optional.absent());
        this.healthcheckUri = healthcheckUri;
        this.healthcheckIntervalSeconds = healthcheckIntervalSeconds;
        this.healthcheckTimeoutSeconds = healthcheckTimeoutSeconds;
        this.healthcheckPortIndex = healthcheckPortIndex;
        this.skipHealthchecksOnDeploy = skipHealthchecksOnDeploy;
        this.healthcheckProtocol = healthcheckProtocol;
        this.healthcheckMaxRetries = healthcheckMaxRetries;
        this.healthcheckMaxTotalTimeoutSeconds = healthcheckMaxTotalTimeoutSeconds;
        this.healthcheck = healthcheckUri.isPresent() && !healthcheck.isPresent() ? Optional.of(new HealthcheckOptions(healthcheckUri.get(), healthcheckPortIndex, Optional.absent(), healthcheckProtocol, Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), healthcheckIntervalSeconds.isPresent() ? Optional.of(healthcheckIntervalSeconds.get().intValue()) : Optional.absent(), healthcheckTimeoutSeconds.isPresent() ? Optional.of(healthcheckTimeoutSeconds.get().intValue()) : Optional.absent(), healthcheckMaxRetries, Optional.absent(), Optional.absent())) : healthcheck;
        this.considerHealthyAfterRunningForSeconds = considerHealthyAfterRunningForSeconds;
        this.deployHealthTimeoutSeconds = deployHealthTimeoutSeconds;
        this.serviceBasePath = serviceBasePath;
        this.loadBalancerGroups = loadBalancerGroups;
        this.loadBalancerPortIndex = loadBalancerPortIndex;
        this.loadBalancerOptions = loadBalancerOptions;
        this.loadBalancerDomains = loadBalancerDomains;
        this.loadBalancerAdditionalRoutes = loadBalancerAdditionalRoutes;
        this.loadBalancerTemplate = loadBalancerTemplate;
        this.loadBalancerServiceIdOverride = loadBalancerServiceIdOverride;
        this.loadBalancerUpstreamGroup = loadBalancerUpstreamGroup;
        this.deployInstanceCountPerStep = deployInstanceCountPerStep;
        this.deployStepWaitTimeMs = deployStepWaitTimeMs;
        this.autoAdvanceDeploySteps = autoAdvanceDeploySteps;
        this.maxTaskRetries = maxTaskRetries;
        this.shell = shell;
        this.user = user;
        this.s3UploaderAdditionalFiles = s3UploaderAdditionalFiles == null ? Collections.emptyList() : s3UploaderAdditionalFiles;
    }

    private static Map<Integer, List<SingularityMesosTaskLabel>> parseMesosTaskLabelsFromMap(Map<Integer, Map<String, String>> taskLabels) {
        HashMap<Integer, List<SingularityMesosTaskLabel>> mesosTaskLabels = new HashMap<Integer, List<SingularityMesosTaskLabel>>();
        for (Map.Entry<Integer, Map<String, String>> entry : taskLabels.entrySet()) {
            mesosTaskLabels.put(entry.getKey(), SingularityMesosTaskLabel.labelsFromMap(entry.getValue()));
        }
        return mesosTaskLabels;
    }

    public SingularityDeployBuilder toBuilder() {
        return new SingularityDeployBuilder(this.requestId, this.id).setCommand(this.command).setArguments(JsonHelpers.copyOfList(this.arguments)).setResources(this.resources).setContainerInfo(this.containerInfo).setCustomExecutorCmd(this.customExecutorCmd).setCustomExecutorId(this.customExecutorId).setCustomExecutorSource(this.customExecutorSource).setCustomExecutorResources(this.customExecutorResources).setHealthcheckUri(this.healthcheckUri).setHealthcheckIntervalSeconds(this.healthcheckIntervalSeconds).setHealthcheckTimeoutSeconds(this.healthcheckTimeoutSeconds).setHealthcheckPortIndex(this.healthcheckPortIndex).setSkipHealthchecksOnDeploy(this.skipHealthchecksOnDeploy).setHealthcheckProtocol(this.healthcheckProtocol).setHealthcheckMaxRetries(this.healthcheckMaxRetries).setHealthcheckMaxTotalTimeoutSeconds(this.healthcheckMaxTotalTimeoutSeconds).setHealthcheck(this.healthcheck).setConsiderHealthyAfterRunningForSeconds(this.considerHealthyAfterRunningForSeconds).setDeployHealthTimeoutSeconds(this.deployHealthTimeoutSeconds).setServiceBasePath(this.serviceBasePath).setLoadBalancerGroups(JsonHelpers.copyOfSet(this.loadBalancerGroups)).setLoadBalancerPortIndex(this.loadBalancerPortIndex).setLoadBalancerOptions(JsonHelpers.copyOfMap(this.loadBalancerOptions)).setLoadBalancerDomains(JsonHelpers.copyOfSet(this.loadBalancerDomains)).setLoadBalancerAdditionalRoutes(JsonHelpers.copyOfList(this.loadBalancerAdditionalRoutes)).setLoadBalancerTemplate(this.loadBalancerTemplate).setLoadBalancerUpstreamGroup(this.loadBalancerUpstreamGroup).setLoadBalancerServiceIdOverride(this.loadBalancerServiceIdOverride).setMetadata(JsonHelpers.copyOfMap(this.metadata)).setVersion(this.version).setTimestamp(this.timestamp).setEnv(JsonHelpers.copyOfMap(this.env)).setTaskEnv(this.taskEnv).setUris(this.uris).setExecutorData(this.executorData).setLabels(this.labels).setMesosLabels(this.mesosLabels).setTaskLabels(this.taskLabels).setMesosTaskLabels(this.mesosTaskLabels).setDeployInstanceCountPerStep(this.deployInstanceCountPerStep).setDeployStepWaitTimeMs(this.deployStepWaitTimeMs).setAutoAdvanceDeploySteps(this.autoAdvanceDeploySteps).setMaxTaskRetries(this.maxTaskRetries).setShell(this.shell).setUser(this.user).setS3UploaderAdditionalFiles(this.s3UploaderAdditionalFiles);
    }

    @Schema(nullable=true, description="Number of seconds that Singularity waits for this service to become healthy (for it to download artifacts, start running, and optionally pass healthchecks)")
    public Optional<Long> getDeployHealthTimeoutSeconds() {
        return this.deployHealthTimeoutSeconds;
    }

    @Schema(required=true, description="Singularity Request Id which is associated with this deploy")
    public String getRequestId() {
        return this.requestId;
    }

    @Schema(required=true, description="Singularity deploy id")
    public String getId() {
        return this.id;
    }

    @Schema(nullable=true, description="Deploy version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @Schema(nullable=true, description="Deploy timestamp")
    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    @Schema(nullable=true, description="Map of metadata key/value pairs associated with the deployment")
    public Optional<Map<String, String>> getMetadata() {
        return this.metadata;
    }

    @Schema(nullable=true, description="Container information for deployment into a container")
    public Optional<SingularityContainerInfo> getContainerInfo() {
        return this.containerInfo;
    }

    @Schema(nullable=true, description="Custom Mesos executor")
    public Optional<String> getCustomExecutorCmd() {
        return this.customExecutorCmd;
    }

    @Schema(nullable=true, description="Custom Mesos executor id")
    public Optional<String> getCustomExecutorId() {
        return this.customExecutorId;
    }

    @Schema(nullable=true, description="Custom Mesos executor source")
    public Optional<String> getCustomExecutorSource() {
        return this.customExecutorSource;
    }

    @Schema(nullable=true, description="Resources to allocate for custom mesos executor")
    public Optional<Resources> getCustomExecutorResources() {
        return this.customExecutorResources;
    }

    @Schema(nullable=true, description="Resources required for this deploy")
    public Optional<Resources> getResources() {
        return this.resources;
    }

    @Schema(nullable=true, description="Command to execute for this deployment")
    public Optional<String> getCommand() {
        return this.command;
    }

    @Schema(nullable=true, description="Command arguments")
    public Optional<List<String>> getArguments() {
        return this.arguments;
    }

    @Schema(nullable=true, description="Map of environment variable definitions")
    public Optional<Map<String, String>> getEnv() {
        return this.env;
    }

    @Schema(nullable=true, description="Map of environment variable overrides for specific task instances (task instance number -> Map<String, String> of environment variables")
    public Optional<Map<Integer, Map<String, String>>> getTaskEnv() {
        return this.taskEnv;
    }

    @Schema(nullable=true, description="Settings used to run this deploy immediately (for non-long-running request types)")
    public Optional<SingularityRunNowRequest> getRunImmediately() {
        return this.runImmediatelyRequest;
    }

    @Schema(nullable=true, description="List of URIs to download before executing the deploy command")
    public Optional<List<SingularityMesosArtifact>> getUris() {
        return this.uris;
    }

    @Schema(nullable=true, description="Executor specific information")
    public Optional<ExecutorData> getExecutorData() {
        return this.executorData;
    }

    @Deprecated
    @Schema(nullable=true, description="Deployment Healthcheck URI, if specified will be called after TASK_RUNNING")
    public Optional<String> getHealthcheckUri() {
        return this.healthcheckUri;
    }

    @Deprecated
    @Schema(nullable=true, description="Healthcheck protocol - HTTP or HTTPS")
    public Optional<HealthcheckProtocol> getHealthcheckProtocol() {
        return this.healthcheckProtocol;
    }

    @Deprecated
    @Schema(nullable=true, description="Time to wait after a failed healthcheck to try again in seconds")
    public Optional<Long> getHealthcheckIntervalSeconds() {
        return this.healthcheckIntervalSeconds;
    }

    @Deprecated
    @Schema(nullable=true, description="Single healthcheck HTTP timeout in seconds")
    public Optional<Long> getHealthcheckTimeoutSeconds() {
        return this.healthcheckTimeoutSeconds;
    }

    @Deprecated
    @Schema(nullable=true, description="Perform healthcheck on this dynamically allocated port (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getHealthcheckPortIndex() {
        return this.healthcheckPortIndex;
    }

    @Schema(nullable=true, description="The base path for the API exposed by the deploy. Used in conjunction with the Load balancer API")
    public Optional<String> getServiceBasePath() {
        return this.serviceBasePath;
    }

    @Schema(nullable=true, description="Number of seconds that a service must be healthy to consider the deployment to be successful")
    public Optional<Long> getConsiderHealthyAfterRunningForSeconds() {
        return this.considerHealthyAfterRunningForSeconds;
    }

    @Schema(nullable=true, description="List of load balancer groups associated with this deployment")
    public Optional<Set<String>> getLoadBalancerGroups() {
        return this.loadBalancerGroups;
    }

    @Schema(nullable=true, description="Send this port to the load balancer api (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getLoadBalancerPortIndex() {
        return this.loadBalancerPortIndex;
    }

    @Schema(nullable=true, description="Map (Key/Value) of options for the load balancer")
    public Optional<Map<String, Object>> getLoadBalancerOptions() {
        return this.loadBalancerOptions;
    }

    @Schema(nullable=true, description="List of domains to host this service on, for use with the load balancer api")
    public Optional<Set<String>> getLoadBalancerDomains() {
        return this.loadBalancerDomains;
    }

    @Schema(nullable=true, description="Additional routes besides serviceBasePath used by this service")
    public Optional<List<String>> getLoadBalancerAdditionalRoutes() {
        return this.loadBalancerAdditionalRoutes;
    }

    @Schema(nullable=true, description="Name of load balancer template to use if not using the default template")
    public Optional<String> getLoadBalancerTemplate() {
        return this.loadBalancerTemplate;
    }

    @Schema(nullable=true, description="Name of load balancer Service ID to use instead of the Request ID")
    public Optional<String> getLoadBalancerServiceIdOverride() {
        return this.loadBalancerServiceIdOverride;
    }

    @Schema(nullable=true, description="Group name to tag all upstreams with in load balancer")
    public Optional<String> getLoadBalancerUpstreamGroup() {
        return this.loadBalancerUpstreamGroup;
    }

    @Deprecated
    @Schema(nullable=true, description="Labels for all tasks associated with this deploy")
    public Optional<Map<String, String>> getLabels() {
        return this.labels;
    }

    @Schema(nullable=true, description="Labels for all tasks associated with this deploy")
    public Optional<List<SingularityMesosTaskLabel>> getMesosLabels() {
        return this.mesosLabels;
    }

    @Schema(nullable=true, description="(Deprecated) Labels for specific tasks associated with this deploy, indexed by instance number")
    public Optional<Map<Integer, Map<String, String>>> getTaskLabels() {
        return this.taskLabels;
    }

    @Schema(nullable=true, description="Labels for specific tasks associated with this deploy, indexed by instance number")
    public Optional<Map<Integer, List<SingularityMesosTaskLabel>>> getMesosTaskLabels() {
        return this.mesosTaskLabels;
    }

    @Schema(nullable=true, description="Allows skipping of health checks when deploying.")
    public Optional<Boolean> getSkipHealthchecksOnDeploy() {
        return this.skipHealthchecksOnDeploy;
    }

    @Deprecated
    @Schema(nullable=true, description="Maximum number of times to retry an individual healthcheck before failing the deploy.")
    public Optional<Integer> getHealthcheckMaxRetries() {
        return this.healthcheckMaxRetries;
    }

    @Deprecated
    @Schema(nullable=true, description="Maximum amount of time to wait before failing a deploy for healthchecks to pass.")
    public Optional<Long> getHealthcheckMaxTotalTimeoutSeconds() {
        return this.healthcheckMaxTotalTimeoutSeconds;
    }

    @Schema(description="HTTP Healthcheck settings")
    public Optional<HealthcheckOptions> getHealthcheck() {
        return this.healthcheck;
    }

    @Schema(nullable=true, description="deploy this many instances at a time")
    public Optional<Integer> getDeployInstanceCountPerStep() {
        return this.deployInstanceCountPerStep;
    }

    @Schema(nullable=true, description="wait this long between deploy steps")
    public Optional<Integer> getDeployStepWaitTimeMs() {
        return this.deployStepWaitTimeMs;
    }

    @Schema(nullable=true, description="automatically advance to the next target instance count after `deployStepWaitTimeMs` seconds")
    public Optional<Boolean> getAutoAdvanceDeploySteps() {
        return this.autoAdvanceDeploySteps;
    }

    @Schema(nullable=true, description="allowed at most this many failed tasks to be retried before failing the deploy")
    public Optional<Integer> getMaxTaskRetries() {
        return this.maxTaskRetries;
    }

    @Schema(nullable=true, description="Override the shell property on the mesos task")
    public Optional<Boolean> getShell() {
        return this.shell;
    }

    @Schema(nullable=true, description="Run tasks as this user")
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(description="Specify additional sandbox files to upload to S3 for this deploy")
    public List<SingularityS3UploaderFile> getS3UploaderAdditionalFiles() {
        return this.s3UploaderAdditionalFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDeploy that = (SingularityDeploy)o;
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.containerInfo != null ? !this.containerInfo.equals(that.containerInfo) : that.containerInfo != null) {
            return false;
        }
        if (this.customExecutorCmd != null ? !this.customExecutorCmd.equals(that.customExecutorCmd) : that.customExecutorCmd != null) {
            return false;
        }
        if (this.customExecutorId != null ? !this.customExecutorId.equals(that.customExecutorId) : that.customExecutorId != null) {
            return false;
        }
        if (this.customExecutorSource != null ? !this.customExecutorSource.equals(that.customExecutorSource) : that.customExecutorSource != null) {
            return false;
        }
        if (this.customExecutorResources != null ? !this.customExecutorResources.equals(that.customExecutorResources) : that.customExecutorResources != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.uris != null ? !this.uris.equals(that.uris) : that.uris != null) {
            return false;
        }
        if (this.executorData != null ? !this.executorData.equals(that.executorData) : that.executorData != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.mesosLabels != null ? !this.mesosLabels.equals(that.mesosLabels) : that.mesosLabels != null) {
            return false;
        }
        if (this.taskLabels != null ? !this.taskLabels.equals(that.taskLabels) : that.taskLabels != null) {
            return false;
        }
        if (this.mesosTaskLabels != null ? !this.mesosTaskLabels.equals(that.mesosTaskLabels) : that.mesosTaskLabels != null) {
            return false;
        }
        if (this.taskEnv != null ? !this.taskEnv.equals(that.taskEnv) : that.taskEnv != null) {
            return false;
        }
        if (this.runImmediatelyRequest != null ? !this.runImmediatelyRequest.equals(that.runImmediatelyRequest) : that.runImmediatelyRequest != null) {
            return false;
        }
        if (this.healthcheckUri != null ? !this.healthcheckUri.equals(that.healthcheckUri) : that.healthcheckUri != null) {
            return false;
        }
        if (this.healthcheckIntervalSeconds != null ? !this.healthcheckIntervalSeconds.equals(that.healthcheckIntervalSeconds) : that.healthcheckIntervalSeconds != null) {
            return false;
        }
        if (this.healthcheckTimeoutSeconds != null ? !this.healthcheckTimeoutSeconds.equals(that.healthcheckTimeoutSeconds) : that.healthcheckTimeoutSeconds != null) {
            return false;
        }
        if (this.healthcheckPortIndex != null ? !this.healthcheckPortIndex.equals(that.healthcheckPortIndex) : that.healthcheckPortIndex != null) {
            return false;
        }
        if (this.healthcheckProtocol != null ? !this.healthcheckProtocol.equals(that.healthcheckProtocol) : that.healthcheckProtocol != null) {
            return false;
        }
        if (this.healthcheckMaxRetries != null ? !this.healthcheckMaxRetries.equals(that.healthcheckMaxRetries) : that.healthcheckMaxRetries != null) {
            return false;
        }
        if (this.healthcheckMaxTotalTimeoutSeconds != null ? !this.healthcheckMaxTotalTimeoutSeconds.equals(that.healthcheckMaxTotalTimeoutSeconds) : that.healthcheckMaxTotalTimeoutSeconds != null) {
            return false;
        }
        if (this.healthcheck != null ? !this.healthcheck.equals(that.healthcheck) : that.healthcheck != null) {
            return false;
        }
        if (this.skipHealthchecksOnDeploy != null ? !this.skipHealthchecksOnDeploy.equals(that.skipHealthchecksOnDeploy) : that.skipHealthchecksOnDeploy != null) {
            return false;
        }
        if (this.deployHealthTimeoutSeconds != null ? !this.deployHealthTimeoutSeconds.equals(that.deployHealthTimeoutSeconds) : that.deployHealthTimeoutSeconds != null) {
            return false;
        }
        if (this.considerHealthyAfterRunningForSeconds != null ? !this.considerHealthyAfterRunningForSeconds.equals(that.considerHealthyAfterRunningForSeconds) : that.considerHealthyAfterRunningForSeconds != null) {
            return false;
        }
        if (this.serviceBasePath != null ? !this.serviceBasePath.equals(that.serviceBasePath) : that.serviceBasePath != null) {
            return false;
        }
        if (this.loadBalancerGroups != null ? !this.loadBalancerGroups.equals(that.loadBalancerGroups) : that.loadBalancerGroups != null) {
            return false;
        }
        if (this.loadBalancerPortIndex != null ? !this.loadBalancerPortIndex.equals(that.loadBalancerPortIndex) : that.loadBalancerPortIndex != null) {
            return false;
        }
        if (this.loadBalancerOptions != null ? !this.loadBalancerOptions.equals(that.loadBalancerOptions) : that.loadBalancerOptions != null) {
            return false;
        }
        if (this.loadBalancerDomains != null ? !this.loadBalancerDomains.equals(that.loadBalancerDomains) : that.loadBalancerDomains != null) {
            return false;
        }
        if (this.loadBalancerAdditionalRoutes != null ? !this.loadBalancerAdditionalRoutes.equals(that.loadBalancerAdditionalRoutes) : that.loadBalancerAdditionalRoutes != null) {
            return false;
        }
        if (this.loadBalancerTemplate != null ? !this.loadBalancerTemplate.equals(that.loadBalancerTemplate) : that.loadBalancerTemplate != null) {
            return false;
        }
        if (this.loadBalancerServiceIdOverride != null ? !this.loadBalancerServiceIdOverride.equals(that.loadBalancerServiceIdOverride) : that.loadBalancerServiceIdOverride != null) {
            return false;
        }
        if (this.loadBalancerUpstreamGroup != null ? !this.loadBalancerUpstreamGroup.equals(that.loadBalancerUpstreamGroup) : that.loadBalancerUpstreamGroup != null) {
            return false;
        }
        if (this.deployInstanceCountPerStep != null ? !this.deployInstanceCountPerStep.equals(that.deployInstanceCountPerStep) : that.deployInstanceCountPerStep != null) {
            return false;
        }
        if (this.deployStepWaitTimeMs != null ? !this.deployStepWaitTimeMs.equals(that.deployStepWaitTimeMs) : that.deployStepWaitTimeMs != null) {
            return false;
        }
        if (this.autoAdvanceDeploySteps != null ? !this.autoAdvanceDeploySteps.equals(that.autoAdvanceDeploySteps) : that.autoAdvanceDeploySteps != null) {
            return false;
        }
        if (this.maxTaskRetries != null ? !this.maxTaskRetries.equals(that.maxTaskRetries) : that.maxTaskRetries != null) {
            return false;
        }
        if (this.shell != null ? !this.shell.equals(that.shell) : that.shell != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return this.s3UploaderAdditionalFiles != null ? this.s3UploaderAdditionalFiles.equals(that.s3UploaderAdditionalFiles) : that.s3UploaderAdditionalFiles == null;
    }

    public int hashCode() {
        int result = this.requestId != null ? this.requestId.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.containerInfo != null ? this.containerInfo.hashCode() : 0);
        result = 31 * result + (this.customExecutorCmd != null ? this.customExecutorCmd.hashCode() : 0);
        result = 31 * result + (this.customExecutorId != null ? this.customExecutorId.hashCode() : 0);
        result = 31 * result + (this.customExecutorSource != null ? this.customExecutorSource.hashCode() : 0);
        result = 31 * result + (this.customExecutorResources != null ? this.customExecutorResources.hashCode() : 0);
        result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
        result = 31 * result + (this.uris != null ? this.uris.hashCode() : 0);
        result = 31 * result + (this.executorData != null ? this.executorData.hashCode() : 0);
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        result = 31 * result + (this.mesosLabels != null ? this.mesosLabels.hashCode() : 0);
        result = 31 * result + (this.taskLabels != null ? this.taskLabels.hashCode() : 0);
        result = 31 * result + (this.mesosTaskLabels != null ? this.mesosTaskLabels.hashCode() : 0);
        result = 31 * result + (this.taskEnv != null ? this.taskEnv.hashCode() : 0);
        result = 31 * result + (this.runImmediatelyRequest != null ? this.runImmediatelyRequest.hashCode() : 0);
        result = 31 * result + (this.healthcheckUri != null ? this.healthcheckUri.hashCode() : 0);
        result = 31 * result + (this.healthcheckIntervalSeconds != null ? this.healthcheckIntervalSeconds.hashCode() : 0);
        result = 31 * result + (this.healthcheckTimeoutSeconds != null ? this.healthcheckTimeoutSeconds.hashCode() : 0);
        result = 31 * result + (this.healthcheckPortIndex != null ? this.healthcheckPortIndex.hashCode() : 0);
        result = 31 * result + (this.healthcheckProtocol != null ? this.healthcheckProtocol.hashCode() : 0);
        result = 31 * result + (this.healthcheckMaxRetries != null ? this.healthcheckMaxRetries.hashCode() : 0);
        result = 31 * result + (this.healthcheckMaxTotalTimeoutSeconds != null ? this.healthcheckMaxTotalTimeoutSeconds.hashCode() : 0);
        result = 31 * result + (this.healthcheck != null ? this.healthcheck.hashCode() : 0);
        result = 31 * result + (this.skipHealthchecksOnDeploy != null ? this.skipHealthchecksOnDeploy.hashCode() : 0);
        result = 31 * result + (this.deployHealthTimeoutSeconds != null ? this.deployHealthTimeoutSeconds.hashCode() : 0);
        result = 31 * result + (this.considerHealthyAfterRunningForSeconds != null ? this.considerHealthyAfterRunningForSeconds.hashCode() : 0);
        result = 31 * result + (this.serviceBasePath != null ? this.serviceBasePath.hashCode() : 0);
        result = 31 * result + (this.loadBalancerGroups != null ? this.loadBalancerGroups.hashCode() : 0);
        result = 31 * result + (this.loadBalancerPortIndex != null ? this.loadBalancerPortIndex.hashCode() : 0);
        result = 31 * result + (this.loadBalancerOptions != null ? this.loadBalancerOptions.hashCode() : 0);
        result = 31 * result + (this.loadBalancerDomains != null ? this.loadBalancerDomains.hashCode() : 0);
        result = 31 * result + (this.loadBalancerAdditionalRoutes != null ? this.loadBalancerAdditionalRoutes.hashCode() : 0);
        result = 31 * result + (this.loadBalancerTemplate != null ? this.loadBalancerTemplate.hashCode() : 0);
        result = 31 * result + (this.loadBalancerServiceIdOverride != null ? this.loadBalancerServiceIdOverride.hashCode() : 0);
        result = 31 * result + (this.loadBalancerUpstreamGroup != null ? this.loadBalancerUpstreamGroup.hashCode() : 0);
        result = 31 * result + (this.deployInstanceCountPerStep != null ? this.deployInstanceCountPerStep.hashCode() : 0);
        result = 31 * result + (this.deployStepWaitTimeMs != null ? this.deployStepWaitTimeMs.hashCode() : 0);
        result = 31 * result + (this.autoAdvanceDeploySteps != null ? this.autoAdvanceDeploySteps.hashCode() : 0);
        result = 31 * result + (this.maxTaskRetries != null ? this.maxTaskRetries.hashCode() : 0);
        result = 31 * result + (this.shell != null ? this.shell.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.s3UploaderAdditionalFiles != null ? this.s3UploaderAdditionalFiles.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SingularityDeploy{requestId='" + this.requestId + '\'' + ", id='" + this.id + '\'' + ", version=" + this.version + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + ", containerInfo=" + this.containerInfo + ", customExecutorCmd=" + this.customExecutorCmd + ", customExecutorId=" + this.customExecutorId + ", customExecutorSource=" + this.customExecutorSource + ", customExecutorResources=" + this.customExecutorResources + ", resources=" + this.resources + ", command=" + this.command + ", arguments=" + this.arguments + ", env=" + this.env + ", uris=" + this.uris + ", executorData=" + this.executorData + ", labels=" + this.labels + ", mesosLabels=" + this.mesosLabels + ", taskLabels=" + this.taskLabels + ", mesosTaskLabels=" + this.mesosTaskLabels + ", taskEnv=" + this.taskEnv + ", runImmediatelyRequest=" + this.runImmediatelyRequest + ", healthcheckUri=" + this.healthcheckUri + ", healthcheckIntervalSeconds=" + this.healthcheckIntervalSeconds + ", healthcheckTimeoutSeconds=" + this.healthcheckTimeoutSeconds + ", healthcheckPortIndex=" + this.healthcheckPortIndex + ", healthcheckProtocol=" + this.healthcheckProtocol + ", healthcheckMaxRetries=" + this.healthcheckMaxRetries + ", healthcheckMaxTotalTimeoutSeconds=" + this.healthcheckMaxTotalTimeoutSeconds + ", healthcheck=" + this.healthcheck + ", skipHealthchecksOnDeploy=" + this.skipHealthchecksOnDeploy + ", deployHealthTimeoutSeconds=" + this.deployHealthTimeoutSeconds + ", considerHealthyAfterRunningForSeconds=" + this.considerHealthyAfterRunningForSeconds + ", serviceBasePath=" + this.serviceBasePath + ", loadBalancerGroups=" + this.loadBalancerGroups + ", loadBalancerPortIndex=" + this.loadBalancerPortIndex + ", loadBalancerOptions=" + this.loadBalancerOptions + ", loadBalancerDomains=" + this.loadBalancerDomains + ", loadBalancerAdditionalRoutes=" + this.loadBalancerAdditionalRoutes + ", loadBalancerTemplate=" + this.loadBalancerTemplate + ", loadBalancerServiceIdOverride=" + this.loadBalancerServiceIdOverride + ", loadBalancerUpstreamGroup=" + this.loadBalancerUpstreamGroup + ", deployInstanceCountPerStep=" + this.deployInstanceCountPerStep + ", deployStepWaitTimeMs=" + this.deployStepWaitTimeMs + ", autoAdvanceDeploySteps=" + this.autoAdvanceDeploySteps + ", maxTaskRetries=" + this.maxTaskRetries + ", shell=" + this.shell + ", user=" + this.user + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + '}';
    }
}

