/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RequestUtilization {
    private final String requestId;
    private final String deployId;
    private long memBytesUsed = 0L;
    private long memBytesReserved = 0L;
    private double cpuUsed = 0.0;
    private double cpuReserved = 0.0;
    private long diskBytesUsed = 0L;
    private long diskBytesReserved = 0L;
    private int numTasks = 0;
    private long maxMemBytesUsed = 0L;
    private long maxMemTimestamp = 0L;
    private long minMemBytesUsed = Long.MAX_VALUE;
    private long minMemTimestamp = 0L;
    private double maxCpuUsed = 0.0;
    private long maxCpusTimestamp = 0L;
    private double minCpuUsed = Double.MAX_VALUE;
    private long minCpusTimestamp = 0L;
    private long maxDiskBytesUsed = 0L;
    private long maxDiskTimestamp = 0L;
    private long minDiskBytesUsed = Long.MAX_VALUE;
    private long minDiskTimestamp = 0L;
    private double cpuBurstRating = 0.0;
    private double percentCpuTimeThrottled = 0.0;
    private double maxPercentCpuTimeThrottled = 0.0;
    private long maxCpuThrottledTimestamp = 0L;
    private double minPercentCpuTimeThrottled = Double.MAX_VALUE;
    private long minCpuThrottledTimestamp = 0L;

    @JsonCreator
    public RequestUtilization(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId) {
        this.requestId = requestId;
        this.deployId = deployId;
    }

    public RequestUtilization addMemBytesUsed(long memBytes) {
        this.memBytesUsed += memBytes;
        return this;
    }

    public RequestUtilization addMemBytesReserved(long memBytes) {
        this.memBytesReserved += memBytes;
        return this;
    }

    public RequestUtilization addCpuUsed(double cpu) {
        this.cpuUsed += cpu;
        return this;
    }

    public RequestUtilization addCpuReserved(double cpu) {
        this.cpuReserved += cpu;
        return this;
    }

    public RequestUtilization addDiskBytesUsed(long diskBytes) {
        this.diskBytesUsed += diskBytes;
        return this;
    }

    public RequestUtilization addDiskBytesReserved(long diskBytes) {
        this.diskBytesReserved += diskBytes;
        return this;
    }

    public RequestUtilization addPercentCpuTimeThrottled(double percentCpuTimeThrottled) {
        this.percentCpuTimeThrottled += percentCpuTimeThrottled;
        return this;
    }

    public RequestUtilization incrementTaskCount() {
        ++this.numTasks;
        return this;
    }

    public long getMemBytesUsed() {
        return this.memBytesUsed;
    }

    public long getMemBytesReserved() {
        return this.memBytesReserved;
    }

    public double getCpuUsed() {
        return this.cpuUsed;
    }

    public double getCpuReserved() {
        return this.cpuReserved;
    }

    public long getDiskBytesUsed() {
        return this.diskBytesUsed;
    }

    public long getDiskBytesReserved() {
        return this.diskBytesReserved;
    }

    public double getPercentCpuTimeThrottled() {
        return this.percentCpuTimeThrottled;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public double getCpuBurstRating() {
        return this.cpuBurstRating;
    }

    @JsonIgnore
    public double getAvgMemBytesUsed() {
        return (double)this.memBytesUsed / (double)this.numTasks;
    }

    @JsonIgnore
    public double getAvgCpuUsed() {
        return this.cpuUsed / (double)this.numTasks;
    }

    @JsonIgnore
    public double getAvgDiskBytesUsed() {
        return (double)this.diskBytesUsed / (double)this.numTasks;
    }

    @JsonIgnore
    public double getAvgPercentCpuTimeThrottled() {
        return this.percentCpuTimeThrottled / (double)this.numTasks;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getMaxMemBytesUsed() {
        return this.maxMemBytesUsed;
    }

    public RequestUtilization setMaxMemBytesUsed(long maxMemBytesUsed) {
        this.maxMemBytesUsed = maxMemBytesUsed;
        return this;
    }

    public double getMaxCpuUsed() {
        return this.maxCpuUsed;
    }

    public RequestUtilization setMaxCpuUsed(double maxCpuUsed) {
        this.maxCpuUsed = maxCpuUsed;
        return this;
    }

    public long getMaxDiskBytesUsed() {
        return this.maxDiskBytesUsed;
    }

    public RequestUtilization setMaxDiskBytesUsed(long maxDiskBytesUsed) {
        this.maxDiskBytesUsed = maxDiskBytesUsed;
        return this;
    }

    public long getMinMemBytesUsed() {
        return this.minMemBytesUsed;
    }

    public RequestUtilization setMinMemBytesUsed(long minMemBytesUsed) {
        this.minMemBytesUsed = minMemBytesUsed;
        return this;
    }

    public double getMinCpuUsed() {
        return this.minCpuUsed;
    }

    public RequestUtilization setMinCpuUsed(double minCpuUsed) {
        this.minCpuUsed = minCpuUsed;
        return this;
    }

    public long getMinDiskBytesUsed() {
        return this.minDiskBytesUsed;
    }

    public RequestUtilization setMinDiskBytesUsed(long minDiskBytesUsed) {
        this.minDiskBytesUsed = minDiskBytesUsed;
        return this;
    }

    public RequestUtilization setCpuBurstRating(double cpuBurstRating) {
        this.cpuBurstRating = cpuBurstRating;
        return this;
    }

    public double getMaxPercentCpuTimeThrottled() {
        return this.maxPercentCpuTimeThrottled;
    }

    public RequestUtilization setMaxPercentCpuTimeThrottled(double maxPercentCpuTimeThrottled) {
        this.maxPercentCpuTimeThrottled = maxPercentCpuTimeThrottled;
        return this;
    }

    public double getMinPercentCpuTimeThrottled() {
        return this.minPercentCpuTimeThrottled;
    }

    public RequestUtilization setMinPercentCpuTimeThrottled(double minPercentCpuTimeThrottled) {
        this.minPercentCpuTimeThrottled = minPercentCpuTimeThrottled;
        return this;
    }

    public long getMaxMemTimestamp() {
        return this.maxMemTimestamp;
    }

    public RequestUtilization setMaxMemTimestamp(long maxMemTimestamp) {
        this.maxMemTimestamp = maxMemTimestamp;
        return this;
    }

    public long getMinMemTimestamp() {
        return this.minMemTimestamp;
    }

    public RequestUtilization setMinMemTimestamp(long minMemTimestamp) {
        this.minMemTimestamp = minMemTimestamp;
        return this;
    }

    public long getMaxCpusTimestamp() {
        return this.maxCpusTimestamp;
    }

    public RequestUtilization setMaxCpusTimestamp(long maxCpusTimestamp) {
        this.maxCpusTimestamp = maxCpusTimestamp;
        return this;
    }

    public long getMinCpusTimestamp() {
        return this.minCpusTimestamp;
    }

    public RequestUtilization setMinCpusTimestamp(long minCpusTimestamp) {
        this.minCpusTimestamp = minCpusTimestamp;
        return this;
    }

    public long getMaxDiskTimestamp() {
        return this.maxDiskTimestamp;
    }

    public RequestUtilization setMaxDiskTimestamp(long maxDiskTimestamp) {
        this.maxDiskTimestamp = maxDiskTimestamp;
        return this;
    }

    public long getMinDiskTimestamp() {
        return this.minDiskTimestamp;
    }

    public RequestUtilization setMinDiskTimestamp(long minDiskTimestamp) {
        this.minDiskTimestamp = minDiskTimestamp;
        return this;
    }

    public long getMaxCpuThrottledTimestamp() {
        return this.maxCpuThrottledTimestamp;
    }

    public RequestUtilization setMaxCpuThrottledTimestamp(long maxCpuThrottledTimestamp) {
        this.maxCpuThrottledTimestamp = maxCpuThrottledTimestamp;
        return this;
    }

    public long getMinCpuThrottledTimestamp() {
        return this.minCpuThrottledTimestamp;
    }

    public RequestUtilization setMinCpuThrottledTimestamp(long minCpuThrottledTimestamp) {
        this.minCpuThrottledTimestamp = minCpuThrottledTimestamp;
        return this;
    }

    public String toString() {
        return "RequestUtilization{requestId='" + this.requestId + '\'' + ", deployId='" + this.deployId + '\'' + ", memBytesUsed=" + this.memBytesUsed + ", memBytesReserved=" + this.memBytesReserved + ", cpuUsed=" + this.cpuUsed + ", cpuReserved=" + this.cpuReserved + ", diskBytesUsed=" + this.diskBytesUsed + ", diskBytesReserved=" + this.diskBytesReserved + ", numTasks=" + this.numTasks + ", maxMemBytesUsed=" + this.maxMemBytesUsed + ", minMemBytesUsed=" + this.minMemBytesUsed + ", maxCpuUsed=" + this.maxCpuUsed + ", minCpuUsed=" + this.minCpuUsed + ", maxDiskBytesUsed=" + this.maxDiskBytesUsed + ", minDiskBytesUsed=" + this.minDiskBytesUsed + ", cpuBurstRating=" + this.cpuBurstRating + ", percentCpuTimeThrottled=" + this.percentCpuTimeThrottled + ", maxPercentCpuTimeThrottled=" + this.maxPercentCpuTimeThrottled + ", minPercentCpuTimeThrottled=" + this.minPercentCpuTimeThrottled + '}';
    }
}

