/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;

public enum LoadBalancerRequestType {
    ADD,
    REMOVE,
    DEPLOY,
    DELETE;


    public static class LoadBalancerRequestId {
        private final String id;
        private final LoadBalancerRequestType requestType;
        private final int attemptNumber;

        @JsonCreator
        public LoadBalancerRequestId(@JsonProperty(value="id") String id, @JsonProperty(value="requestType") LoadBalancerRequestType requestType, @JsonProperty(value="attemptNumber") Optional<Integer> attemptNumber) {
            this.id = id;
            this.requestType = requestType;
            this.attemptNumber = attemptNumber.or(1);
        }

        public String toString() {
            return String.format("%s-%s-%s", new Object[]{this.id, this.requestType, this.attemptNumber});
        }

        public String getId() {
            return this.id;
        }

        public LoadBalancerRequestType getRequestType() {
            return this.requestType;
        }

        public int getAttemptNumber() {
            return this.attemptNumber;
        }
    }
}

