/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.protos;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.protos.MesosExecutorInfo;
import com.hubspot.mesos.protos.MesosLabels;
import com.hubspot.mesos.protos.MesosResourceObject;
import com.hubspot.mesos.protos.MesosStringValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="The mesos protos representation of a task")
public class MesosTaskObject {
    private final MesosStringValue taskId;
    private final Optional<MesosExecutorInfo> executor;
    private final MesosLabels labels;
    private final MesosStringValue agentId;
    private final MesosStringValue slaveId;
    private final List<MesosResourceObject> resources;
    private final String name;
    private final Map<String, Object> allOtherFields;

    @JsonCreator
    public MesosTaskObject(@JsonProperty(value="taskId") MesosStringValue taskId, @JsonProperty(value="executor") Optional<MesosExecutorInfo> executor, @JsonProperty(value="labels") MesosLabels labels, @JsonProperty(value="agentId") MesosStringValue agentId, @JsonProperty(value="slaveId") MesosStringValue slaveId, @JsonProperty(value="resources") List<MesosResourceObject> resources, @JsonProperty(value="name") String name) {
        this.taskId = taskId;
        this.executor = executor;
        this.labels = labels;
        this.agentId = agentId != null ? agentId : slaveId;
        this.slaveId = agentId != null ? agentId : slaveId;
        this.resources = resources != null ? resources : Collections.emptyList();
        this.name = name;
        this.allOtherFields = new HashMap<String, Object>();
    }

    public MesosStringValue getTaskId() {
        return this.taskId;
    }

    public MesosExecutorInfo getExecutor() {
        return this.executor.orNull();
    }

    public boolean hasExecutor() {
        return this.executor.isPresent();
    }

    public MesosLabels getLabels() {
        return this.labels;
    }

    public MesosStringValue getAgentId() {
        return this.agentId;
    }

    public MesosStringValue getSlaveId() {
        return this.slaveId;
    }

    public List<MesosResourceObject> getResources() {
        return this.resources;
    }

    @JsonAnyGetter
    public Map<String, Object> getAllOtherFields() {
        return this.allOtherFields;
    }

    @JsonAnySetter
    public void setAllOtherFields(String name, Object value) {
        this.allOtherFields.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MesosTaskObject) {
            MesosTaskObject that = (MesosTaskObject)obj;
            return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.executor, that.executor) && Objects.equals(this.labels, that.labels) && Objects.equals(this.agentId, that.agentId) && Objects.equals(this.slaveId, that.slaveId) && Objects.equals(this.resources, that.resources) && Objects.equals(this.name, that.name) && Objects.equals(this.allOtherFields, that.allOtherFields);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.executor, this.labels, this.agentId, this.slaveId, this.resources, this.name, this.allOtherFields);
    }

    public String toString() {
        return "MesosTaskObject{taskId=" + this.taskId + ", executor=" + this.executor + ", labels=" + this.labels + ", agentId=" + this.agentId + ", slaveId=" + this.slaveId + ", resources=" + this.resources + ", name='" + this.name + '\'' + ", allOtherFields=" + this.allOtherFields + '}';
    }
}

