/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.protos;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.mesos.protos.MesosStringValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="The mesos protos representation of an offer")
public class MesosOfferObject {
    private final MesosStringValue agentId;
    private final MesosStringValue slaveId;
    private final MesosStringValue frameworkId;
    private final String hostname;
    private final MesosStringValue id;
    private final Map<String, Object> allOtherFields;

    @JsonCreator
    public MesosOfferObject(@JsonProperty(value="agentId") MesosStringValue agentId, @JsonProperty(value="slaveId") MesosStringValue slaveId, @JsonProperty(value="frameworkId") MesosStringValue frameworkId, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="id") MesosStringValue id) {
        this.agentId = agentId != null ? agentId : slaveId;
        this.slaveId = agentId != null ? agentId : slaveId;
        this.frameworkId = frameworkId;
        this.hostname = hostname;
        this.id = id;
        this.allOtherFields = new HashMap<String, Object>();
    }

    @JsonIgnore
    public MesosOfferObject sizeOptimized() {
        MesosOfferObject optimized = new MesosOfferObject(this.agentId, null, this.frameworkId, this.hostname, this.id);
        optimized.setAllOtherFields("url", this.allOtherFields.get("url"));
        return optimized;
    }

    public MesosStringValue getAgentId() {
        return this.agentId;
    }

    public MesosStringValue getSlaveId() {
        return this.slaveId;
    }

    public MesosStringValue getFrameworkId() {
        return this.frameworkId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public MesosStringValue getId() {
        return this.id;
    }

    @JsonAnyGetter
    public Map<String, Object> getAllOtherFields() {
        return this.allOtherFields;
    }

    @JsonAnySetter
    public void setAllOtherFields(String name, Object value) {
        this.allOtherFields.put(name, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MesosOfferObject) {
            MesosOfferObject that = (MesosOfferObject)obj;
            return Objects.equals(this.agentId, that.agentId) && Objects.equals(this.slaveId, that.slaveId) && Objects.equals(this.frameworkId, that.frameworkId) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.id, that.id) && Objects.equals(this.allOtherFields, that.allOtherFields);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.agentId, this.slaveId, this.frameworkId, this.hostname, this.id, this.allOtherFields);
    }

    public String toString() {
        return "MesosOfferObject{agentId=" + this.agentId + ", slaveId=" + this.slaveId + ", frameworkId=" + this.frameworkId + ", hostname='" + this.hostname + '\'' + ", id=" + this.id + ", allOtherFields=" + this.allOtherFields + '}';
    }
}

