/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Represents a docker port mapping")
@Beta
public class SingularityPortMapping {
    private final int hostPort;
    private final int containerPort;
    private final Optional<String> protocol;

    @JsonCreator
    public SingularityPortMapping(@JsonProperty(value="hostPort") int hostPort, @JsonProperty(value="containerPort") int containerPort, @JsonProperty(value="protocol") Optional<String> protocol) {
        this.hostPort = hostPort;
        this.containerPort = containerPort;
        this.protocol = protocol;
    }

    @Schema(required=true, description="the port to map from on the host network interface")
    public int getHostPort() {
        return this.hostPort;
    }

    @Schema(required=true, description="the port to map to on the container network interface")
    public int getContainerPort() {
        return this.containerPort;
    }

    @Schema(description="the protocol e.g. 'tcp' or 'udp'")
    public Optional<String> getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityPortMapping that = (SingularityPortMapping)o;
        return this.hostPort == that.hostPort && this.containerPort == that.containerPort && Objects.equals(this.protocol, that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.hostPort, this.containerPort, this.protocol);
    }

    public String toString() {
        return "SingularityPortMapping{hostPort='" + this.hostPort + '\'' + ", containerPort=" + this.containerPort + ", protocol=" + this.protocol + '}';
    }
}

