/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityAppcImage;
import com.hubspot.mesos.SingularityDockerImage;
import com.hubspot.mesos.SingularityMesosImageType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Describes a container image to be launched in mesos")
@Beta
public class SingularityMesosImage {
    private final SingularityMesosImageType type;
    private final Optional<SingularityAppcImage> appc;
    private final Optional<SingularityDockerImage> docker;
    private final boolean cached;

    @JsonCreator
    public SingularityMesosImage(@JsonProperty(value="type") SingularityMesosImageType type, @JsonProperty(value="appc") Optional<SingularityAppcImage> appc, @JsonProperty(value="docker") Optional<SingularityDockerImage> docker, @JsonProperty(value="cached") Boolean cached) {
        this.type = type;
        this.appc = appc;
        this.docker = docker;
        this.cached = MoreObjects.firstNonNull(cached, true);
    }

    @Schema(required=true, description="Mesos image type")
    public SingularityMesosImageType getType() {
        return this.type;
    }

    @Schema(description="Appc image configuration")
    public Optional<SingularityAppcImage> getAppc() {
        return this.appc;
    }

    @Schema(description="Docker image configuration")
    public Optional<SingularityDockerImage> getDocker() {
        return this.docker;
    }

    @Schema(description="Determines if a cached image is considered up to date")
    public boolean isCached() {
        return this.cached;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityMesosImage that = (SingularityMesosImage)o;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.appc, that.appc) && Objects.equals(this.docker, that.docker) && Objects.equals(this.cached, that.cached);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.appc, this.docker, this.cached});
    }

    public String toString() {
        return "SingularityMesosImage{type='" + (Object)((Object)this.type) + '\'' + "appc='" + this.appc + '\'' + "docker='" + this.docker + '\'' + "cached='" + this.cached + '\'' + '}';
    }
}

