/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Describes an artifact to be downloaded")
public class SingularityMesosArtifact {
    private final String uri;
    private final boolean cache;
    private final boolean executable;
    private final boolean extract;
    private final Optional<String> outputFile;

    @JsonCreator
    public static SingularityMesosArtifact fromString(String uri) {
        return new SingularityMesosArtifact(uri, Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
    }

    @JsonCreator
    public SingularityMesosArtifact(@JsonProperty(value="uri") String uri, @JsonProperty(value="cache") Optional<Boolean> cache, @JsonProperty(value="executable") Optional<Boolean> executable, @JsonProperty(value="extract") Optional<Boolean> extract, @JsonProperty(value="outputFile") Optional<String> outputFile) {
        this.uri = uri;
        this.cache = cache.or(false);
        this.executable = executable.or(false);
        this.extract = extract.or(true);
        this.outputFile = outputFile;
    }

    @Schema(required=true, description="The uri of the artifact to download")
    public String getUri() {
        return this.uri;
    }

    @Schema(description="Cache this artifact to avoid multiple downloads on the same host", defaultValue="false")
    public boolean isCache() {
        return this.cache;
    }

    @Schema(description="If true, chmod the download file so it is executable", defaultValue="false")
    public boolean isExecutable() {
        return this.executable;
    }

    @Schema(title="If true, unpack the downloaded artifact in teh sandbox directory", defaultValue="true", description="Recognized file types: .tar, .tar.gz, .tar.bz2, .tar.xz, .gz, .tgz, .tbz2, .txz, .zip")
    public boolean isExtract() {
        return this.extract;
    }

    @Schema(title="The destination filename for the download", nullable=true, defaultValue="original name of the file")
    public Optional<String> getOutputFile() {
        return this.outputFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityMesosArtifact that = (SingularityMesosArtifact)o;
        return this.cache == that.cache && this.executable == that.executable && this.extract == that.extract && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.cache, this.executable, this.extract);
    }

    public String toString() {
        return "SingularityMesosArtifact{uri='" + this.uri + '\'' + ", cache=" + this.cache + ", executable=" + this.executable + ", extract=" + this.extract + '}';
    }
}

