/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@Schema(description="Describes a volume to be mounted in a docker container")
@Beta
public class SingularityDockerVolume {
    private final Optional<String> driver;
    private final Optional<String> name;
    private final Map<String, String> driverOptions;

    @JsonCreator
    public SingularityDockerVolume(@JsonProperty(value="driver") Optional<String> driver, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="driverOptions") Map<String, String> driverOptions) {
        this.driver = driver;
        this.name = name;
        this.driverOptions = MoreObjects.firstNonNull(driverOptions, Collections.emptyMap());
    }

    @Schema(description="Docker volume driver name")
    public Optional<String> getDriver() {
        return this.driver;
    }

    @Schema(description="Volume name '%i' will be replaced with the instance index")
    public Optional<String> getName() {
        return this.name;
    }

    @Schema(description="Volume driver options")
    public Map<String, String> getDriverOptions() {
        return this.driverOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDockerVolume that = (SingularityDockerVolume)o;
        return Objects.equals(this.driver, that.driver) && Objects.equals(this.name, that.name) && Objects.equals(this.driverOptions, that.driverOptions);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.name, this.driverOptions);
    }

    public String toString() {
        return "SingularityDockerVolume{driver='" + this.driver + '\'' + ", name=" + this.name + ", driverOptions=" + this.driverOptions + '}';
    }
}

