/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.serializers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.ProtobufSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MessageSerializer
extends ProtobufSerializer<MessageOrBuilder> {
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ProtobufJacksonConfig config;

    @Deprecated
    public MessageSerializer(ExtensionRegistryWrapper extensionRegistry) {
        this(ProtobufJacksonConfig.builder().extensionRegistry(extensionRegistry).build());
    }

    public MessageSerializer(ProtobufJacksonConfig config) {
        super(MessageOrBuilder.class);
        this.config = config;
    }

    @Override
    public void serialize(MessageOrBuilder message, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        boolean proto3 = message.getDescriptorForType().getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3;
        JsonInclude.Include include = serializerProvider.getConfig().getDefaultPropertyInclusion().getValueInclusion();
        boolean writeDefaultValues = proto3 && include != JsonInclude.Include.NON_DEFAULT;
        boolean writeEmptyCollections = include != JsonInclude.Include.NON_DEFAULT && include != JsonInclude.Include.NON_EMPTY;
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(serializerProvider.getConfig().getPropertyNamingStrategy());
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        ArrayList<Descriptors.FieldDescriptor> fields = new ArrayList<Descriptors.FieldDescriptor>(descriptor.getFields());
        if (message instanceof GeneratedMessageV3.ExtendableMessageOrBuilder) {
            for (ExtensionRegistry.ExtensionInfo extensionInfo : this.config.extensionRegistry().getExtensionsByDescriptor(descriptor)) {
                fields.add(extensionInfo.descriptor);
            }
        }
        for (Descriptors.FieldDescriptor field : fields) {
            if (field.isRepeated()) {
                List valueList = (List)message.getField(field);
                if (valueList.isEmpty() && !writeEmptyCollections) continue;
                if (field.isMapField()) {
                    generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                    this.writeMap(field, valueList, generator, serializerProvider);
                    continue;
                }
                if (valueList.size() == 1 && MessageSerializer.writeSingleElementArraysUnwrapped(serializerProvider)) {
                    generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                    this.writeValue(field, valueList.get(0), generator, serializerProvider);
                    continue;
                }
                generator.writeArrayFieldStart(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                for (Object subValue : valueList) {
                    this.writeValue(field, subValue, generator, serializerProvider);
                }
                generator.writeEndArray();
                continue;
            }
            if (message.hasField(field) || writeDefaultValues && !MessageSerializer.supportsFieldPresence(field) && field.getContainingOneof() == null) {
                generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                this.writeValue(field, message.getField(field), generator, serializerProvider);
                continue;
            }
            if (include != JsonInclude.Include.ALWAYS || field.getContainingOneof() != null) continue;
            generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
            generator.writeNull();
        }
        generator.writeEndObject();
    }

    private static boolean supportsFieldPresence(Descriptors.FieldDescriptor field) {
        return field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
    }

    private static boolean writeEmptyArrays(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
    }

    private static boolean writeSingleElementArraysUnwrapped(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
    }
}

