/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.protobuf.NullValue;
import java.io.IOException;

public class NullValueDeserializer
extends StdDeserializer<NullValue> {
    public NullValueDeserializer() {
        super(NullValue.class);
    }

    @Override
    public NullValue deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_NULL: {
                return NullValue.NULL_VALUE;
            }
        }
        context.reportWrongTokenException(NullValue.class, JsonToken.VALUE_NULL, NullValueDeserializer.wrongTokenMessage(context), new Object[0]);
        throw new AssertionError();
    }

    @Override
    public NullValue getNullValue(DeserializationContext ctxt) {
        return NullValue.NULL_VALUE;
    }

    private static String wrongTokenMessage(DeserializationContext context) {
        return "Can not deserialize instance of com.google.protobuf.NullValue out of " + (Object)((Object)context.getParser().currentToken()) + " token";
    }
}

