/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ProtobufSerializer<T extends MessageOrBuilder>
extends StdSerializer<T> {
    private static final String NULL_VALUE_FULL_NAME = NullValue.getDescriptor().getFullName();
    private final Map<Class<?>, JsonSerializer<Object>> serializerCache = new ConcurrentHashMap();

    public ProtobufSerializer(Class<T> protobufType) {
        super(protobufType);
    }

    protected void writeMap(Descriptors.FieldDescriptor field, Object entries, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        Descriptors.Descriptor entryDescriptor = field.getMessageType();
        Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.findFieldByName("key");
        Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.findFieldByName("value");
        generator.writeStartObject();
        for (Message entry : (List)entries) {
            generator.writeFieldName(entry.getField(keyDescriptor).toString());
            Object value = entry.getField(valueDescriptor);
            this.writeValue(valueDescriptor, value, generator, serializerProvider);
        }
        generator.writeEndObject();
    }

    protected void writeValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        switch (field.getJavaType()) {
            case INT: {
                generator.writeNumber((Integer)value);
                break;
            }
            case LONG: {
                generator.writeNumber((Long)value);
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber((Double)value);
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean((Boolean)value);
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumDescriptor = (Descriptors.EnumValueDescriptor)value;
                if (NULL_VALUE_FULL_NAME.equals(enumDescriptor.getType().getFullName())) {
                    generator.writeNull();
                    break;
                }
                if (ProtobufSerializer.writeEnumsUsingIndex(serializerProvider)) {
                    generator.writeNumber(enumDescriptor.getNumber());
                    break;
                }
                generator.writeString(enumDescriptor.getName());
                break;
            }
            case BYTE_STRING: {
                generator.writeString(serializerProvider.getConfig().getBase64Variant().encode(((ByteString)value).toByteArray()));
                break;
            }
            case MESSAGE: {
                Class<?> subType = value.getClass();
                JsonSerializer<Object> serializer = this.serializerCache.get(subType);
                if (serializer == null) {
                    serializer = serializerProvider.findValueSerializer(value.getClass(), null);
                    this.serializerCache.put(subType, serializer);
                }
                serializer.serialize(value, generator, serializerProvider);
                break;
            }
            default: {
                throw ProtobufSerializer.unrecognizedType(field, generator);
            }
        }
    }

    private static boolean writeEnumsUsingIndex(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    private static IOException unrecognizedType(Descriptors.FieldDescriptor field, JsonGenerator generator) throws IOException {
        String error = String.format("Unrecognized java type '%s' for field %s", new Object[]{field.getJavaType(), field.getFullName()});
        throw new JsonGenerationException(error, generator);
    }
}

