/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ExtensionRegistryWrapper {
    private final Function<Descriptors.Descriptor, Set<ExtensionRegistry.ExtensionInfo>> extensionFunction;

    private ExtensionRegistryWrapper() {
        this.extensionFunction = new Function<Descriptors.Descriptor, Set<ExtensionRegistry.ExtensionInfo>>(){

            @Override
            public Set<ExtensionRegistry.ExtensionInfo> apply(Descriptors.Descriptor descriptor) {
                return Collections.emptySet();
            }
        };
    }

    private ExtensionRegistryWrapper(final ExtensionRegistry extensionRegistry) {
        this.extensionFunction = new Function<Descriptors.Descriptor, Set<ExtensionRegistry.ExtensionInfo>>(){
            private final Map<Descriptors.Descriptor, Set<ExtensionRegistry.ExtensionInfo>> extensionCache = new ConcurrentHashMap<Descriptors.Descriptor, Set<ExtensionRegistry.ExtensionInfo>>();

            @Override
            public Set<ExtensionRegistry.ExtensionInfo> apply(Descriptors.Descriptor descriptor) {
                Set<ExtensionRegistry.ExtensionInfo> cached = this.extensionCache.get(descriptor);
                if (cached != null) {
                    return cached;
                }
                Set<ExtensionRegistry.ExtensionInfo> extensions = extensionRegistry.getAllImmutableExtensionsByExtendedType(descriptor.getFullName());
                this.extensionCache.put(descriptor, extensions);
                return extensions;
            }
        };
    }

    public static ExtensionRegistryWrapper wrap(ExtensionRegistry extensionRegistry) {
        return new ExtensionRegistryWrapper(extensionRegistry);
    }

    public static ExtensionRegistryWrapper empty() {
        return new ExtensionRegistryWrapper();
    }

    @Deprecated
    public List<ExtensionRegistry.ExtensionInfo> findExtensionsByDescriptor(Descriptors.Descriptor descriptor) {
        return new ArrayList<ExtensionRegistry.ExtensionInfo>(this.getExtensionsByDescriptor(descriptor));
    }

    public Set<ExtensionRegistry.ExtensionInfo> getExtensionsByDescriptor(Descriptors.Descriptor descriptor) {
        return this.extensionFunction.apply(descriptor);
    }

    private static interface Function<T, V> {
        public V apply(T var1);
    }
}

