/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.google.common.base.Optional;
import com.hubspot.deploy.HealthcheckOptions;
import com.hubspot.singularity.HealthcheckMethod;
import com.hubspot.singularity.HealthcheckProtocol;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class HealthcheckOptionsBuilder {
    @NotNull
    private Optional<String> uri;
    private Optional<Integer> portIndex;
    private Optional<Long> portNumber;
    private Optional<HealthcheckProtocol> protocol;
    private Optional<HealthcheckMethod> method;
    private Optional<Integer> startupTimeoutSeconds;
    private Optional<Integer> startupDelaySeconds;
    private Optional<Integer> startupIntervalSeconds;
    private Optional<Integer> intervalSeconds;
    private Optional<Integer> responseTimeoutSeconds;
    private Optional<Integer> maxRetries;
    private Optional<List<Integer>> failureStatusCodes;
    private Optional<String> healthcheckResultFilePath;

    public HealthcheckOptionsBuilder(String uri) {
        this(Optional.of(uri));
    }

    public HealthcheckOptionsBuilder(Optional<String> uri) {
        this.uri = uri;
        this.portIndex = Optional.absent();
        this.portNumber = Optional.absent();
        this.protocol = Optional.absent();
        this.method = Optional.absent();
        this.startupTimeoutSeconds = Optional.absent();
        this.startupDelaySeconds = Optional.absent();
        this.startupIntervalSeconds = Optional.absent();
        this.intervalSeconds = Optional.absent();
        this.responseTimeoutSeconds = Optional.absent();
        this.maxRetries = Optional.absent();
        this.failureStatusCodes = Optional.absent();
        this.healthcheckResultFilePath = Optional.absent();
    }

    public Optional<String> getUri() {
        return this.uri;
    }

    public HealthcheckOptionsBuilder setUri(String uri) {
        this.uri = Optional.of(uri);
        return this;
    }

    public Optional<Integer> getPortIndex() {
        return this.portIndex;
    }

    public HealthcheckOptionsBuilder setPortIndex(Optional<Integer> portIndex) {
        this.portIndex = portIndex;
        return this;
    }

    public Optional<Long> getPortNumber() {
        return this.portNumber;
    }

    public HealthcheckOptionsBuilder setPortNumber(Optional<Long> portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public Optional<HealthcheckProtocol> getProtocol() {
        return this.protocol;
    }

    public HealthcheckOptionsBuilder setProtocol(Optional<HealthcheckProtocol> protocol) {
        this.protocol = protocol;
        return this;
    }

    public Optional<HealthcheckMethod> getMethod() {
        return this.method;
    }

    public HealthcheckOptionsBuilder setMethod(Optional<HealthcheckMethod> method) {
        this.method = method;
        return this;
    }

    public Optional<Integer> getStartupTimeoutSeconds() {
        return this.startupTimeoutSeconds;
    }

    public HealthcheckOptionsBuilder setStartupTimeoutSeconds(Optional<Integer> startupTimeoutSeconds) {
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        return this;
    }

    public Optional<Integer> getStartupDelaySeconds() {
        return this.startupDelaySeconds;
    }

    public HealthcheckOptionsBuilder setStartupDelaySeconds(Optional<Integer> startupDelaySeconds) {
        this.startupDelaySeconds = startupDelaySeconds;
        return this;
    }

    public Optional<Integer> getStartupIntervalSeconds() {
        return this.startupIntervalSeconds;
    }

    public HealthcheckOptionsBuilder setStartupIntervalSeconds(Optional<Integer> startupIntervalSeconds) {
        this.startupIntervalSeconds = startupIntervalSeconds;
        return this;
    }

    public Optional<Integer> getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public HealthcheckOptionsBuilder setIntervalSeconds(Optional<Integer> intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
        return this;
    }

    public Optional<Integer> getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public HealthcheckOptionsBuilder setResponseTimeoutSeconds(Optional<Integer> responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        return this;
    }

    public Optional<Integer> getMaxRetries() {
        return this.maxRetries;
    }

    public HealthcheckOptionsBuilder setMaxRetries(Optional<Integer> maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Optional<List<Integer>> getFailureStatusCodes() {
        return this.failureStatusCodes;
    }

    public HealthcheckOptionsBuilder setFailureStatusCodes(Optional<List<Integer>> failureStatusCodes) {
        this.failureStatusCodes = failureStatusCodes;
        return this;
    }

    public Optional<String> getHealthcheckResultFilePath() {
        return this.healthcheckResultFilePath;
    }

    public HealthcheckOptionsBuilder setHealthcheckResultFilePath(Optional<String> healthcheckResultFilePath) {
        this.healthcheckResultFilePath = healthcheckResultFilePath;
        return this;
    }

    public HealthcheckOptions build() {
        return new HealthcheckOptions(this.uri, this.portIndex, this.portNumber, this.protocol, this.method, this.startupTimeoutSeconds, this.startupDelaySeconds, this.startupIntervalSeconds, this.intervalSeconds, this.responseTimeoutSeconds, this.maxRetries, this.failureStatusCodes, this.healthcheckResultFilePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthcheckOptionsBuilder that = (HealthcheckOptionsBuilder)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.portIndex, that.portIndex) && Objects.equals(this.portNumber, that.portNumber) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.method, that.method) && Objects.equals(this.startupTimeoutSeconds, that.startupTimeoutSeconds) && Objects.equals(this.startupDelaySeconds, that.startupDelaySeconds) && Objects.equals(this.startupIntervalSeconds, that.startupIntervalSeconds) && Objects.equals(this.intervalSeconds, that.intervalSeconds) && Objects.equals(this.responseTimeoutSeconds, that.responseTimeoutSeconds) && Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.failureStatusCodes, that.failureStatusCodes) && Objects.equals(this.healthcheckResultFilePath, that.healthcheckResultFilePath);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.portIndex, this.portNumber, this.protocol, this.method, this.startupTimeoutSeconds, this.startupDelaySeconds, this.startupIntervalSeconds, this.intervalSeconds, this.responseTimeoutSeconds, this.maxRetries, this.failureStatusCodes, this.healthcheckResultFilePath);
    }

    public String toString() {
        return "HealthcheckOptionsBuilder{uri='" + this.uri + '\'' + ", portIndex=" + this.portIndex + ", portNumber=" + this.portNumber + ", protocol=" + this.protocol + ", method=" + this.method + ", startupTimeoutSeconds=" + this.startupTimeoutSeconds + ", startupDelaySeconds=" + this.startupDelaySeconds + ", startupIntervalSeconds=" + this.startupIntervalSeconds + ", intervalSeconds=" + this.intervalSeconds + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", maxRetries=" + this.maxRetries + ", failureStatusCodes=" + this.failureStatusCodes + ", healthcheckResultFilePath=" + this.healthcheckResultFilePath + '}';
    }
}

