/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.HealthcheckOptionsBuilder;
import com.hubspot.singularity.HealthcheckMethod;
import com.hubspot.singularity.HealthcheckProtocol;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@Schema(description="Describes health check behavior for tasks associated with a deploy")
public class HealthcheckOptions {
    @NotNull
    private final Optional<String> uri;
    private final Optional<Integer> portIndex;
    private final Optional<Long> portNumber;
    private final Optional<HealthcheckProtocol> protocol;
    private final Optional<HealthcheckMethod> method;
    private final Optional<Integer> startupTimeoutSeconds;
    private final Optional<Integer> startupDelaySeconds;
    private final Optional<Integer> startupIntervalSeconds;
    private final Optional<Integer> intervalSeconds;
    private final Optional<Integer> responseTimeoutSeconds;
    private final Optional<Integer> maxRetries;
    private final Optional<List<Integer>> failureStatusCodes;
    private final Optional<String> healthcheckResultFilePath;

    @JsonCreator
    public HealthcheckOptions(@JsonProperty(value="uri") Optional<String> uri, @JsonProperty(value="portIndex") Optional<Integer> portIndex, @JsonProperty(value="portNumber") Optional<Long> portNumber, @JsonProperty(value="protocol") Optional<HealthcheckProtocol> protocol, @JsonProperty(value="method") Optional<HealthcheckMethod> method, @JsonProperty(value="startupTimeoutSeconds") Optional<Integer> startupTimeoutSeconds, @JsonProperty(value="startupDelaySeconds") Optional<Integer> startupDelaySeconds, @JsonProperty(value="startupIntervalSeconds") Optional<Integer> startupIntervalSeconds, @JsonProperty(value="intervalSeconds") Optional<Integer> intervalSeconds, @JsonProperty(value="responseTimeoutSeconds") Optional<Integer> responseTimeoutSeconds, @JsonProperty(value="maxRetries") Optional<Integer> maxRetries, @JsonProperty(value="failureStatusCodes") Optional<List<Integer>> failureStatusCodes, @JsonProperty(value="healthcheckResultFilePath") Optional<String> healthcheckResultFilePath) {
        this.uri = uri;
        this.portIndex = portIndex;
        this.portNumber = portNumber;
        this.protocol = protocol;
        this.method = method;
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        this.startupDelaySeconds = startupDelaySeconds;
        this.startupIntervalSeconds = startupIntervalSeconds;
        this.intervalSeconds = intervalSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.maxRetries = maxRetries;
        this.failureStatusCodes = failureStatusCodes;
        this.healthcheckResultFilePath = healthcheckResultFilePath;
    }

    public HealthcheckOptions(String uri, Optional<Integer> portIndex, Optional<Long> portNumber, Optional<HealthcheckProtocol> protocol, Optional<HealthcheckMethod> method, Optional<Integer> startupTimeoutSeconds, Optional<Integer> startupDelaySeconds, Optional<Integer> startupIntervalSeconds, Optional<Integer> intervalSeconds, Optional<Integer> responseTimeoutSeconds, Optional<Integer> maxRetries, Optional<List<Integer>> failureStatusCodes, Optional<String> healthcheckResultFilePath) {
        this.uri = Optional.of(uri);
        this.portIndex = portIndex;
        this.portNumber = portNumber;
        this.protocol = protocol;
        this.method = method;
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        this.startupDelaySeconds = startupDelaySeconds;
        this.startupIntervalSeconds = startupIntervalSeconds;
        this.intervalSeconds = intervalSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.maxRetries = maxRetries;
        this.failureStatusCodes = failureStatusCodes;
        this.healthcheckResultFilePath = healthcheckResultFilePath;
    }

    @JsonIgnore
    public HealthcheckOptionsBuilder toBuilder() {
        return new HealthcheckOptionsBuilder(this.uri).setPortIndex(this.portIndex).setPortNumber(this.portNumber).setProtocol(this.protocol).setMethod(this.method).setStartupTimeoutSeconds(this.startupTimeoutSeconds).setStartupDelaySeconds(this.startupDelaySeconds).setStartupIntervalSeconds(this.startupIntervalSeconds).setIntervalSeconds(this.intervalSeconds).setResponseTimeoutSeconds(this.responseTimeoutSeconds).setMaxRetries(this.maxRetries).setFailureStatusCodes(this.failureStatusCodes).setHealthcheckResultFilePath(this.healthcheckResultFilePath);
    }

    @Schema(required=true, description="Healthcheck uri to hit")
    public Optional<String> getUri() {
        return this.uri;
    }

    @Schema(description="Perform healthcheck on this dynamically allocated port (e.g. 0 for first port); defaults to first port")
    public Optional<Integer> getPortIndex() {
        return this.portIndex;
    }

    @Schema(description="Perform healthcheck on this port (portIndex cannot also be used when using this setting)")
    public Optional<Long> getPortNumber() {
        return this.portNumber;
    }

    @Schema(description="Healthcheck protocol - HTTP or HTTPS for HTTP/1, HTTP2 or HTTPS2 for HTTP/2")
    public Optional<HealthcheckProtocol> getProtocol() {
        return this.protocol;
    }

    @Schema(description="Healthcheck HTTP method - GET or POST; GET by default")
    public Optional<HealthcheckMethod> getMethod() {
        return this.method;
    }

    @Schema(description="Consider the task unhealthy/failed if the app has not started responding to healthchecks in this amount of time")
    public Optional<Integer> getStartupTimeoutSeconds() {
        return this.startupTimeoutSeconds;
    }

    @Schema(description="Wait this long before issuing the first healthcheck")
    public Optional<Integer> getStartupDelaySeconds() {
        return this.startupDelaySeconds;
    }

    @Schema(description="Time to wait after a failed healthcheck to try again in seconds.")
    public Optional<Integer> getStartupIntervalSeconds() {
        return this.startupIntervalSeconds;
    }

    @Schema(description="Time to wait after a valid but failed healthcheck response to try again in seconds.")
    public Optional<Integer> getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Schema(description="Single healthcheck HTTP timeout in seconds.")
    public Optional<Integer> getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    @Schema(description="Maximum number of times to retry an individual healthcheck before failing the deploy.")
    public Optional<Integer> getMaxRetries() {
        return this.maxRetries;
    }

    @Schema(description="Fail the healthcheck with no further retries if one of these status codes is returned")
    public Optional<List<Integer>> getFailureStatusCodes() {
        return this.failureStatusCodes;
    }

    @Schema(description="File path that indicates successful non-web health checks.")
    public Optional<String> getHealthcheckResultFilePath() {
        return this.healthcheckResultFilePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthcheckOptions that = (HealthcheckOptions)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.portIndex, that.portIndex) && Objects.equals(this.portNumber, that.portNumber) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.method, that.method) && Objects.equals(this.startupTimeoutSeconds, that.startupTimeoutSeconds) && Objects.equals(this.startupDelaySeconds, that.startupDelaySeconds) && Objects.equals(this.startupIntervalSeconds, that.startupIntervalSeconds) && Objects.equals(this.intervalSeconds, that.intervalSeconds) && Objects.equals(this.responseTimeoutSeconds, that.responseTimeoutSeconds) && Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.failureStatusCodes, that.failureStatusCodes) && Objects.equals(this.healthcheckResultFilePath, that.healthcheckResultFilePath);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.portIndex, this.portNumber, this.protocol, this.method, this.startupTimeoutSeconds, this.startupDelaySeconds, this.startupIntervalSeconds, this.intervalSeconds, this.responseTimeoutSeconds, this.maxRetries, this.failureStatusCodes, this.healthcheckResultFilePath);
    }

    public String toString() {
        return "HealthcheckOptions{uri='" + this.uri + '\'' + ", portIndex=" + this.portIndex + ", portNumber=" + this.portNumber + ", protocol=" + this.protocol + ", method=" + this.method + ", startupTimeoutSeconds=" + this.startupTimeoutSeconds + ", startupDelaySeconds=" + this.startupDelaySeconds + ", startupIntervalSeconds=" + this.startupIntervalSeconds + ", intervalSeconds=" + this.intervalSeconds + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", maxRetries=" + this.maxRetries + ", failureStatusCodes=" + this.failureStatusCodes + ", healthcheckResultFilePath=" + this.healthcheckResultFilePath + '}';
    }
}

