/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.RemoteArtifact;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An artifact identified by url")
public class ExternalArtifact
extends RemoteArtifact {
    private final String url;

    @JsonCreator
    public ExternalArtifact(@JsonProperty(value="name") String name, @JsonProperty(value="filename") String filename, @JsonProperty(value="md5sum") Optional<String> md5sum, @JsonProperty(value="url") String url, @JsonProperty(value="filesize") Optional<Long> filesize, @JsonProperty(value="targetFolderRelativeToTask") Optional<String> targetFolderRelativeToTask, @JsonProperty(value="isArtifactList") Optional<Boolean> isArtifactList) {
        super(name, filename, md5sum, filesize, targetFolderRelativeToTask, isArtifactList);
        this.url = url;
    }

    @Schema(description="URL to download the artifact")
    public String getUrl() {
        return this.url;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        ExternalArtifact that = (ExternalArtifact)other;
        return Objects.equals(this.url, that.url);
    }

    @Override
    public String toString() {
        return "ExternalArtifact{url='" + this.url + '\'' + "} " + super.toString();
    }
}

