/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UpstreamInfo {
    public static final String DEFAULT_GROUP = "default";
    private final String upstream;
    private final String resolvedUpstream;
    @Size(max=250)
    @Pattern(regexp="^$|[^\\s/|]+", message="cannot contain whitespace, '/', or '|'")
    private final String requestId;
    @Size(max=100)
    @Pattern(regexp="^$|[^\\s|]+", message="cannot contain whitespace, '/', or '|'")
    private final String rackId;
    private final Optional<String> originalPath;
    @Size(max=100)
    @Pattern(regexp="^$|[^\\s|]+", message="cannot contain whitespace, '/', or '|'")
    private final String group;

    public static boolean upstreamAndGroupMatches(UpstreamInfo a, UpstreamInfo b) {
        return a.getUpstream().equals(b.getUpstream()) && a.getGroup().equals(b.getGroup());
    }

    @JsonCreator
    public static UpstreamInfo fromString(String value) {
        String[] split = value.split("\\|", -1);
        if (split[0].contains(".") && split.length == 1) {
            return UpstreamInfo.fromUnEncodedString(value);
        }
        String upstream = new String(BaseEncoding.base64Url().decode(split[0]), Charsets.UTF_8);
        Optional<String> requestId = split.length > 1 && !split[1].equals("") ? Optional.of(split[1]) : Optional.absent();
        Optional<String> rackId = split.length > 2 && !split[2].equals("") ? Optional.of(split[2]) : Optional.absent();
        Optional<String> group = split.length > 3 && !split[3].equals("") ? Optional.of(split[3]) : Optional.absent();
        Optional<String> resolvedUpstream = split.length > 4 && !split[4].equals("") ? Optional.of(split[4]) : Optional.absent();
        return new UpstreamInfo(upstream, requestId, rackId, Optional.of(value), group, resolvedUpstream);
    }

    public static UpstreamInfo fromUnEncodedString(String upstream) {
        return new UpstreamInfo(upstream, Optional.absent(), Optional.absent(), Optional.of(upstream), Optional.absent(), Optional.absent());
    }

    public UpstreamInfo(String upstream, Optional<String> requestId, Optional<String> rackId) {
        this(upstream, requestId, rackId, Optional.absent(), Optional.absent(), Optional.absent());
    }

    public UpstreamInfo(String upstream, Optional<String> requestId, Optional<String> rackId, Optional<String> group) {
        this(upstream, requestId, rackId, Optional.absent(), group, Optional.absent());
    }

    public UpstreamInfo(String upstream, Optional<String> requestId, Optional<String> rackId, Optional<String> originalPath, Optional<String> group) {
        this(upstream, requestId, rackId, originalPath, group, Optional.absent());
    }

    @JsonCreator
    public UpstreamInfo(@JsonProperty(value="upstream") String upstream, @JsonProperty(value="requestId") Optional<String> requestId, @JsonProperty(value="rackId") Optional<String> rackId, @JsonProperty(value="originalPath") Optional<String> originalPath, @JsonProperty(value="group") Optional<String> group, @JsonProperty(value="resolvedUpstream") Optional<String> resolvedUpstream) {
        this.upstream = upstream;
        this.requestId = requestId.or("");
        this.rackId = rackId.or("");
        this.originalPath = originalPath;
        this.group = group.or(DEFAULT_GROUP);
        this.resolvedUpstream = resolvedUpstream.or("");
    }

    public String getUpstream() {
        return this.upstream;
    }

    public Optional<String> getResolvedUpstream() {
        return Strings.isNullOrEmpty(this.resolvedUpstream) ? Optional.absent() : Optional.of(this.resolvedUpstream);
    }

    public Optional<String> getRequestId() {
        return Strings.isNullOrEmpty(this.requestId) ? Optional.absent() : Optional.of(this.requestId);
    }

    public Optional<String> getRackId() {
        return Strings.isNullOrEmpty(this.rackId) ? Optional.absent() : Optional.of(this.rackId);
    }

    @JsonIgnore
    public Optional<String> getOriginalPath() {
        return this.originalPath;
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        return this.upstream;
    }

    public String toPath() {
        return String.format("%s|%s|%s|%s|%s", this.sanitizeUpstream(this.upstream), this.requestId, this.rackId, this.group, this.resolvedUpstream);
    }

    protected String sanitizeUpstream(String name) {
        return BaseEncoding.base64Url().encode(name.getBytes(Charsets.UTF_8));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpstreamInfo that = (UpstreamInfo)o;
        if (!this.rackId.equals(that.rackId)) {
            return false;
        }
        if (!this.requestId.equals(that.requestId)) {
            return false;
        }
        if (!this.upstream.equals(that.upstream)) {
            return false;
        }
        if (!this.resolvedUpstream.equals(that.resolvedUpstream)) {
            return false;
        }
        if (!this.originalPath.equals(that.originalPath)) {
            return false;
        }
        return this.group.equals(that.group);
    }

    public int hashCode() {
        int result = this.upstream.hashCode();
        result = 31 * result + this.resolvedUpstream.hashCode();
        result = 31 * result + this.requestId.hashCode();
        result = 31 * result + this.rackId.hashCode();
        result = 31 * result + this.originalPath.hashCode();
        result = 31 * result + this.group.hashCode();
        return result;
    }
}

