/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.baragon.models.RegisterBy;
import com.hubspot.baragon.models.TrafficSourceType;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class TrafficSource {
    @Size(min=1)
    private final String name;
    @NotNull
    private final TrafficSourceType type;
    private final RegisterBy registerBy;

    @JsonCreator
    public static TrafficSource fromString(String input) {
        return new TrafficSource(input, TrafficSourceType.CLASSIC, RegisterBy.INSTANCE_ID);
    }

    public TrafficSource(String name, TrafficSourceType type) {
        this(name, type, RegisterBy.INSTANCE_ID);
    }

    @JsonCreator
    public TrafficSource(@JsonProperty(value="name") String name, @JsonProperty(value="type") TrafficSourceType type, @JsonProperty(value="registerBy") RegisterBy registerBy) {
        this.name = name;
        this.type = type;
        this.registerBy = registerBy == null ? RegisterBy.INSTANCE_ID : registerBy;
    }

    public String getName() {
        return this.name;
    }

    public TrafficSourceType getType() {
        return this.type;
    }

    public RegisterBy getRegisterBy() {
        return this.registerBy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TrafficSource) {
            TrafficSource that = (TrafficSource)obj;
            return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals((Object)this.registerBy, (Object)that.registerBy);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.registerBy});
    }

    public String toString() {
        return "TrafficSource{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", registerBy=" + (Object)((Object)this.registerBy) + '}';
    }
}

