/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.hubspot.baragon.models.BaragonGroupAlias;
import com.hubspot.baragon.models.BaragonServiceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonService {
    @NotNull
    @Pattern(regexp="[^\\s/|]+", message="cannot contain whitespace, '/', or '|'", flags={Pattern.Flag.MULTILINE})
    private final String serviceId;
    @NotNull
    private final Collection<String> owners;
    @NotNull
    private final String serviceBasePath;
    private final List<String> additionalPaths;
    @NotNull
    @Size(min=1)
    private final Set<String> loadBalancerGroups;
    private final Map<String, Object> options;
    private final Optional<String> templateName;
    private final Set<String> domains;
    @Deprecated
    private final Optional<String> edgeCacheDNS;
    private final Set<String> edgeCacheDomains;
    private final boolean preResolveUpstreamDNS;

    public BaragonService(@JsonProperty(value="serviceId") String serviceId, @JsonProperty(value="owners") Collection<String> owners, @JsonProperty(value="serviceBasePath") String serviceBasePath, @JsonProperty(value="additionalPaths") List<String> additionalPaths, @JsonProperty(value="loadBalancerGroups") Set<String> loadBalancerGroups, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="templateName") Optional<String> templateName, @JsonProperty(value="domains") Set<String> domains, @JsonProperty(value="edgeCacheDNS") Optional<String> edgeCacheDNS, @JsonProperty(value="edgeCacheDomains") Set<String> edgeCacheDomains, @JsonProperty(value="preResolveUpstreamDNS") boolean preResolveUpstreamDNS) {
        HashSet<String> edgeDomains;
        this.serviceId = serviceId;
        this.owners = owners;
        this.serviceBasePath = serviceBasePath;
        this.additionalPaths = MoreObjects.firstNonNull(additionalPaths, Collections.emptyList());
        this.loadBalancerGroups = loadBalancerGroups;
        this.options = options;
        this.templateName = templateName;
        this.domains = MoreObjects.firstNonNull(domains, Collections.emptySet());
        this.edgeCacheDNS = edgeCacheDNS;
        HashSet<String> hashSet = edgeDomains = edgeCacheDomains != null ? Sets.newHashSet(edgeCacheDomains) : new HashSet<String>();
        if (edgeCacheDNS.isPresent()) {
            edgeDomains.add(edgeCacheDNS.get());
        }
        this.edgeCacheDomains = edgeDomains;
        this.preResolveUpstreamDNS = preResolveUpstreamDNS;
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, List<String> additionalPaths, Set<String> loadBalancerGroups, Map<String, Object> options, Optional<String> templateName, Set<String> domains, Optional<String> edgeCacheDNS, Set<String> edgeCacheDomains) {
        this(serviceId, owners, serviceBasePath, additionalPaths, loadBalancerGroups, options, templateName, domains, edgeCacheDNS, edgeCacheDomains, false);
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, List<String> additionalPaths, Set<String> loadBalancerGroups, Map<String, Object> options, Optional<String> templateName, Set<String> domains, Optional<String> edgeCacheDNS) {
        this(serviceId, owners, serviceBasePath, additionalPaths, loadBalancerGroups, options, templateName, domains, edgeCacheDNS, Collections.emptySet(), false);
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, List<String> additionalPaths, Set<String> loadBalancerGroups, Map<String, Object> options, Optional<String> templateName, Set<String> domains, Set<String> edgeCacheDomains) {
        this(serviceId, owners, serviceBasePath, additionalPaths, loadBalancerGroups, options, templateName, domains, Optional.absent(), edgeCacheDomains, false);
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, List<String> additionalPaths, Set<String> loadBalancerGroups, Map<String, Object> options, Optional<String> templateName, Set<String> domains) {
        this(serviceId, owners, serviceBasePath, additionalPaths, loadBalancerGroups, options, templateName, domains, Optional.absent(), Collections.emptySet(), false);
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, List<String> additionalPaths, Set<String> loadBalancerGroups, Map<String, Object> options, Optional<String> templateName) {
        this(serviceId, owners, serviceBasePath, additionalPaths, loadBalancerGroups, options, templateName, Collections.emptySet(), Optional.absent(), Collections.emptySet(), false);
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, Set<String> loadBalancerGroups, Map<String, Object> options) {
        this(serviceId, owners, serviceBasePath, Collections.emptyList(), loadBalancerGroups, options, Optional.absent(), Collections.emptySet(), Optional.absent(), Collections.emptySet(), false);
    }

    public BaragonService withUpdatedGroups(BaragonGroupAlias updatedFromAlias) {
        return new BaragonServiceBuilder().setServiceId(this.serviceId).setOwners(this.owners).setServiceBasePath(this.serviceBasePath).setAdditionalPaths(this.additionalPaths).setLoadBalancerGroups(updatedFromAlias.getGroups()).setOptions(this.options).setTemplateName(this.templateName).setDomains(updatedFromAlias.getDomains()).setEdgeCacheDomains(updatedFromAlias.getEdgeCacheDomains()).setPreResolveUpstreamDNS(this.preResolveUpstreamDNS).build();
    }

    public BaragonService withDomains(Set<String> domains) {
        return new BaragonServiceBuilder().setServiceId(this.serviceId).setOwners(this.owners).setServiceBasePath(this.serviceBasePath).setAdditionalPaths(this.additionalPaths).setLoadBalancerGroups(this.loadBalancerGroups).setOptions(this.options).setTemplateName(this.templateName).setDomains(domains).setEdgeCacheDomains(this.edgeCacheDomains).setPreResolveUpstreamDNS(this.preResolveUpstreamDNS).build();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Collection<String> getOwners() {
        return this.owners;
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }

    public List<String> getAdditionalPaths() {
        return this.additionalPaths;
    }

    public Set<String> getLoadBalancerGroups() {
        return this.loadBalancerGroups;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Optional<String> getTemplateName() {
        return this.templateName;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    public Optional<String> getEdgeCacheDNS() {
        return this.edgeCacheDNS;
    }

    public Set<String> getEdgeCacheDomains() {
        return this.edgeCacheDomains;
    }

    public boolean isPreResolveUpstreamDNS() {
        return this.preResolveUpstreamDNS;
    }

    @JsonIgnore
    public List<String> getAllPaths(Optional<String> defaultDomain) {
        ArrayList<String> allPaths = new ArrayList<String>();
        for (String path : this.additionalPaths) {
            if (!this.domains.isEmpty()) {
                for (String domain : this.domains) {
                    allPaths.add(String.format("%s%s", domain, path));
                    if (!defaultDomain.isPresent() || !domain.equals(defaultDomain.get())) continue;
                    allPaths.add(path);
                }
                continue;
            }
            allPaths.add(path);
        }
        if (!this.domains.isEmpty()) {
            for (String domain : this.domains) {
                allPaths.add(String.format("%s%s", domain, this.serviceBasePath));
                if (!defaultDomain.isPresent() || !domain.equals(defaultDomain.get())) continue;
                allPaths.add(this.serviceBasePath);
            }
        } else {
            allPaths.add(this.serviceBasePath);
        }
        return allPaths;
    }

    public String toString() {
        return "BaragonService{serviceId='" + this.serviceId + '\'' + ", owners=" + this.owners + ", serviceBasePath='" + this.serviceBasePath + '\'' + ", additionalPaths=" + this.additionalPaths + ", loadBalancerGroups=" + this.loadBalancerGroups + ", options=" + this.options + ", templateName=" + this.templateName + ", domains=" + this.domains + ", edgeCacheDNS=" + this.edgeCacheDNS + ", edgeCacheDomains=" + this.edgeCacheDomains + ", preResolveUpstreamDNS=" + this.preResolveUpstreamDNS + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaragonService) {
            BaragonService that = (BaragonService)obj;
            return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.owners, that.owners) && Objects.equals(this.serviceBasePath, that.serviceBasePath) && Objects.equals(this.additionalPaths, that.additionalPaths) && Objects.equals(this.loadBalancerGroups, that.loadBalancerGroups) && Objects.equals(this.options, that.options) && Objects.equals(this.templateName, that.templateName) && Objects.equals(this.domains, that.domains) && Objects.equals(this.edgeCacheDNS, that.edgeCacheDNS) && Objects.equals(this.edgeCacheDomains, that.edgeCacheDomains) && Objects.equals(this.preResolveUpstreamDNS, that.preResolveUpstreamDNS);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.owners, this.serviceBasePath, this.additionalPaths, this.loadBalancerGroups, this.options, this.templateName, this.domains, this.edgeCacheDNS, this.edgeCacheDomains, this.preResolveUpstreamDNS);
    }
}

