/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.google.common.base.Optional;
import com.hubspot.baragon.models.BaragonRequest;
import com.hubspot.baragon.models.BaragonService;
import com.hubspot.baragon.models.RequestAction;
import com.hubspot.baragon.models.UpstreamInfo;
import java.util.Collections;
import java.util.List;

public class BaragonRequestBuilder {
    private String loadBalancerRequestId;
    private BaragonService loadBalancerService;
    private List<UpstreamInfo> addUpstreams;
    private List<UpstreamInfo> removeUpstreams;
    private List<UpstreamInfo> replaceUpstreams = Collections.emptyList();
    private Optional<String> replaceServiceId = Optional.absent();
    private Optional<RequestAction> action = Optional.of(RequestAction.UPDATE);
    private Boolean noValidate = false;
    private Boolean noReload = false;
    private Boolean upstreamUpdateOnly = false;
    private Boolean noDuplicateUpstreams = false;

    public BaragonRequestBuilder setLoadBalancerRequestId(String loadBalancerRequestId) {
        this.loadBalancerRequestId = loadBalancerRequestId;
        return this;
    }

    public BaragonRequestBuilder setLoadBalancerService(BaragonService loadBalancerService) {
        this.loadBalancerService = loadBalancerService;
        return this;
    }

    public BaragonRequestBuilder setAddUpstreams(List<UpstreamInfo> addUpstreams) {
        this.addUpstreams = addUpstreams;
        return this;
    }

    public BaragonRequestBuilder setRemoveUpstreams(List<UpstreamInfo> removeUpstreams) {
        this.removeUpstreams = removeUpstreams;
        return this;
    }

    public BaragonRequestBuilder setReplaceUpstreams(List<UpstreamInfo> replaceUpstreams) {
        this.replaceUpstreams = replaceUpstreams;
        return this;
    }

    public BaragonRequestBuilder setAction(Optional<RequestAction> action) {
        this.action = action;
        return this;
    }

    public BaragonRequestBuilder setNoValidate(Boolean noValidate) {
        this.noValidate = noValidate;
        return this;
    }

    public BaragonRequestBuilder setNoReload(Boolean noReload) {
        this.noReload = noReload;
        return this;
    }

    public BaragonRequestBuilder setUpstreamUpdateOnly(Boolean upstreamUpdateOnly) {
        this.upstreamUpdateOnly = upstreamUpdateOnly;
        return this;
    }

    public BaragonRequestBuilder setNoDuplicateUpstreams(Boolean noDuplicateUpstreams) {
        this.noDuplicateUpstreams = noDuplicateUpstreams;
        return this;
    }

    public BaragonRequest build() {
        return new BaragonRequest(this.loadBalancerRequestId, this.loadBalancerService, this.addUpstreams, this.removeUpstreams, this.replaceUpstreams, this.replaceServiceId, this.action, this.noValidate, this.noReload, this.upstreamUpdateOnly, this.noDuplicateUpstreams);
    }
}

