/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.hubspot.baragon.models.BaragonGroupAlias;
import com.hubspot.baragon.models.BaragonRequestBuilder;
import com.hubspot.baragon.models.BaragonService;
import com.hubspot.baragon.models.RequestAction;
import com.hubspot.baragon.models.UpstreamInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonRequest {
    @NotNull
    @Pattern(regexp="[^\\s/|]+", message="cannot contain whitespace, '/', or '|'", flags={Pattern.Flag.MULTILINE})
    private final String loadBalancerRequestId;
    @NotNull
    @Valid
    private final BaragonService loadBalancerService;
    @NotNull
    @Valid
    private final List<UpstreamInfo> addUpstreams;
    @NotNull
    @Valid
    private final List<UpstreamInfo> removeUpstreams;
    @Deprecated
    private final Optional<String> replaceServiceId;
    private final Optional<RequestAction> action;
    @Valid
    private final List<UpstreamInfo> replaceUpstreams;
    @NotNull
    private final boolean noValidate;
    @NotNull
    private final boolean noReload;
    @NotNull
    private final boolean upstreamUpdateOnly;
    @NotNull
    private final boolean noDuplicateUpstreams;

    @JsonCreator
    public BaragonRequest(@JsonProperty(value="loadBalancerRequestId") String loadBalancerRequestId, @JsonProperty(value="loadBalancerService") BaragonService loadBalancerService, @JsonProperty(value="addUpstreams") List<UpstreamInfo> addUpstreams, @JsonProperty(value="removeUpstreams") List<UpstreamInfo> removeUpstreams, @JsonProperty(value="replaceUpstreams") List<UpstreamInfo> replaceUpstreams, @JsonProperty(value="replaceServiceId") Optional<String> replaceServiceId, @JsonProperty(value="action") Optional<RequestAction> action, @JsonProperty(value="noValidate") Boolean noValidate, @JsonProperty(value="noReload") Boolean noReload, @JsonProperty(value="upstreamUpdateOnly") Boolean upstreamUpdateOnly, @JsonProperty(value="noDuplicateUpstreams") Boolean noDuplicateUpstreams) {
        this.loadBalancerRequestId = loadBalancerRequestId;
        this.loadBalancerService = loadBalancerService;
        this.addUpstreams = this.addRequestId(addUpstreams, loadBalancerRequestId);
        this.removeUpstreams = this.addRequestId(removeUpstreams, loadBalancerRequestId);
        this.replaceServiceId = replaceServiceId;
        this.action = action;
        this.replaceUpstreams = MoreObjects.firstNonNull(replaceUpstreams, Collections.emptyList());
        this.noValidate = MoreObjects.firstNonNull(noValidate, false);
        this.noReload = MoreObjects.firstNonNull(noReload, false);
        this.upstreamUpdateOnly = MoreObjects.firstNonNull(upstreamUpdateOnly, false);
        this.noDuplicateUpstreams = MoreObjects.firstNonNull(noDuplicateUpstreams, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, List<UpstreamInfo> replaceUpstreams, Optional<String> replaceServiceId, Optional<RequestAction> action, boolean noValidate, boolean noReload, boolean upstreamUpdateOnly) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, replaceUpstreams, replaceServiceId, action, noValidate, noReload, upstreamUpdateOnly, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, List<UpstreamInfo> replaceUpstreams, Optional<String> replaceServiceId, Optional<RequestAction> action, boolean noValidate, boolean noReload) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, replaceUpstreams, replaceServiceId, action, noValidate, noReload, false, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, List<UpstreamInfo> replaceUpstreams, Optional<String> replaceServiceId, Optional<RequestAction> action, boolean noValidate) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, replaceUpstreams, replaceServiceId, action, noValidate, false, false, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, List<UpstreamInfo> replaceUpstreams, Optional<String> replaceServiceId, Optional<RequestAction> action) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, replaceUpstreams, replaceServiceId, action, false, false, false, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, Optional<String> replaceServiceId) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, Collections.emptyList(), replaceServiceId, Optional.of(RequestAction.UPDATE), false, false, false, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, Collections.emptyList(), Optional.absent(), Optional.of(RequestAction.UPDATE), false, false, false, false);
    }

    public BaragonRequest withUpdatedGroups(BaragonGroupAlias updatedFromAlias) {
        return this.toBuilder().setLoadBalancerService(this.loadBalancerService.withUpdatedGroups(updatedFromAlias)).build();
    }

    public BaragonRequest withUpdatedDomains(Set<String> domains) {
        return this.toBuilder().setLoadBalancerService(this.loadBalancerService.withDomains(domains)).build();
    }

    public String getLoadBalancerRequestId() {
        return this.loadBalancerRequestId;
    }

    public BaragonService getLoadBalancerService() {
        return this.loadBalancerService;
    }

    public List<UpstreamInfo> getAddUpstreams() {
        return this.addUpstreams;
    }

    public List<UpstreamInfo> getRemoveUpstreams() {
        return this.removeUpstreams;
    }

    public List<UpstreamInfo> getReplaceUpstreams() {
        return this.replaceUpstreams;
    }

    public Optional<String> getReplaceServiceId() {
        return this.replaceServiceId;
    }

    public Optional<RequestAction> getAction() {
        return this.action;
    }

    private List<UpstreamInfo> addRequestId(List<UpstreamInfo> upstreams, String requestId) {
        if (upstreams == null || requestId == null) {
            return upstreams;
        }
        ArrayList<UpstreamInfo> upstreamsWithRequestId = Lists.newArrayListWithCapacity(upstreams.size());
        for (UpstreamInfo upstream : upstreams) {
            upstreamsWithRequestId.add(this.addRequestId(upstream, requestId));
        }
        return upstreamsWithRequestId;
    }

    private UpstreamInfo addRequestId(UpstreamInfo upstream, String requestId) {
        if (!upstream.getRequestId().isPresent()) {
            return new UpstreamInfo(upstream.getUpstream(), Optional.of(requestId), upstream.getRackId(), Optional.of(upstream.getGroup()));
        }
        return upstream;
    }

    public boolean isNoValidate() {
        return this.noValidate;
    }

    public boolean isNoReload() {
        return this.noReload;
    }

    public boolean isUpstreamUpdateOnly() {
        return this.upstreamUpdateOnly;
    }

    public boolean isNoDuplicateUpstreams() {
        return this.noDuplicateUpstreams;
    }

    public String toString() {
        return "BaragonRequest [loadBalancerRequestId='" + this.loadBalancerRequestId + '\'' + ", loadBalancerService=" + this.loadBalancerService + ", addUpstreams=" + this.addUpstreams + ", removeUpstreams=" + this.removeUpstreams + ", replaceUpstreams=" + this.replaceUpstreams + ", replaceServiceId=" + this.replaceServiceId + ", action=" + this.action + ", noValidate=" + this.noValidate + ", noReload=" + this.noReload + ", upstreamUpdateOnly=" + this.upstreamUpdateOnly + ", noDuplicateUpstreams=" + this.noDuplicateUpstreams + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonRequest request = (BaragonRequest)o;
        if (!this.addUpstreams.equals(request.addUpstreams)) {
            return false;
        }
        if (!this.loadBalancerRequestId.equals(request.loadBalancerRequestId)) {
            return false;
        }
        if (!this.loadBalancerService.equals(request.loadBalancerService)) {
            return false;
        }
        if (!this.removeUpstreams.equals(request.removeUpstreams)) {
            return false;
        }
        if (!this.replaceUpstreams.equals(request.replaceUpstreams)) {
            return false;
        }
        if (!this.replaceServiceId.equals(request.replaceServiceId)) {
            return false;
        }
        if (!this.action.equals(request.getAction())) {
            return false;
        }
        if (!this.noValidate == request.noValidate) {
            return false;
        }
        if (!this.noReload == request.noReload) {
            return false;
        }
        if (!this.upstreamUpdateOnly == request.upstreamUpdateOnly) {
            return false;
        }
        return !this.noDuplicateUpstreams != request.noDuplicateUpstreams;
    }

    public BaragonRequestBuilder toBuilder() {
        return new BaragonRequestBuilder().setLoadBalancerService(this.loadBalancerService).setAddUpstreams(this.addUpstreams).setRemoveUpstreams(this.removeUpstreams).setReplaceUpstreams(this.replaceUpstreams).setLoadBalancerRequestId(this.loadBalancerRequestId).setAction(this.action).setNoValidate(this.noValidate).setNoReload(this.noReload).setUpstreamUpdateOnly(this.upstreamUpdateOnly).setNoDuplicateUpstreams(this.noDuplicateUpstreams);
    }

    public int hashCode() {
        int result = this.loadBalancerRequestId.hashCode();
        result = 31 * result + this.loadBalancerService.hashCode();
        result = 31 * result + this.addUpstreams.hashCode();
        result = 31 * result + this.removeUpstreams.hashCode();
        result = 31 * result + this.replaceUpstreams.hashCode();
        result = 31 * result + this.replaceServiceId.hashCode();
        result = 31 * result + this.action.hashCode();
        result = 31 * result + (this.noValidate ? 1 : 0);
        result = 31 * result + (this.noReload ? 1 : 0);
        result = 31 * result + (this.upstreamUpdateOnly ? 1 : 0);
        result = 31 * result + (this.noDuplicateUpstreams ? 1 : 0);
        return result;
    }
}

