/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.hubspot.baragon.exceptions.InvalidAgentMetadataStringException;
import com.hubspot.baragon.models.BaragonAgentEc2Metadata;
import com.hubspot.baragon.models.BaragonAgentGcloudMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentMetadata {
    public static final Pattern AGENT_METADATA_STRING_REGEX = Pattern.compile("^http[s]?:\\/\\/([^:\\/]+:\\d{1,5})\\/.*$");
    private final String baseAgentUri;
    @Deprecated
    private final Optional<String> domain;
    private final String agentId;
    private final BaragonAgentEc2Metadata ec2;
    private final Optional<BaragonAgentGcloudMetadata> gcloud;
    private final Map<String, String> extraAgentData;
    private final boolean batchEnabled;

    @JsonCreator
    public static BaragonAgentMetadata fromString(String value) {
        Matcher matcher = AGENT_METADATA_STRING_REGEX.matcher(value);
        if (!matcher.matches()) {
            throw new InvalidAgentMetadataStringException(value);
        }
        return new BaragonAgentMetadata(value, matcher.group(1), Optional.absent(), new BaragonAgentEc2Metadata(Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent()), Optional.absent(), Collections.emptyMap(), false);
    }

    @JsonCreator
    public BaragonAgentMetadata(@JsonProperty(value="baseAgentUri") String baseAgentUri, @JsonProperty(value="agentId") String agentId, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="ec2") BaragonAgentEc2Metadata ec2, @JsonProperty(value="gcloud") Optional<BaragonAgentGcloudMetadata> gcloud, @JsonProperty(value="extraAgentData") Map<String, String> extraAgentData, @JsonProperty(value="batchEnabled") boolean batchEnabled) {
        this.baseAgentUri = baseAgentUri;
        this.domain = domain;
        this.agentId = agentId;
        this.ec2 = ec2;
        this.gcloud = gcloud;
        this.extraAgentData = MoreObjects.firstNonNull(extraAgentData, Collections.emptyMap());
        this.batchEnabled = MoreObjects.firstNonNull(batchEnabled, false);
    }

    public String getBaseAgentUri() {
        return this.baseAgentUri;
    }

    @Deprecated
    public Optional<String> getDomain() {
        return this.domain;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public BaragonAgentEc2Metadata getEc2() {
        return this.ec2;
    }

    public Optional<BaragonAgentGcloudMetadata> getGcloud() {
        return this.gcloud;
    }

    public Map<String, String> getExtraAgentData() {
        return this.extraAgentData;
    }

    public boolean isBatchEnabled() {
        return this.batchEnabled;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaragonAgentMetadata) {
            BaragonAgentMetadata that = (BaragonAgentMetadata)obj;
            return Objects.equals(this.batchEnabled, that.batchEnabled) && Objects.equals(this.baseAgentUri, that.baseAgentUri) && Objects.equals(this.domain, that.domain) && Objects.equals(this.agentId, that.agentId) && Objects.equals(this.ec2, that.ec2) && Objects.equals(this.gcloud, that.gcloud) && Objects.equals(this.extraAgentData, that.extraAgentData);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.baseAgentUri, this.domain, this.agentId, this.ec2, this.gcloud, this.extraAgentData, this.batchEnabled);
    }

    public String toString() {
        return "BaragonAgentMetadata{baseAgentUri='" + this.baseAgentUri + '\'' + ", domain=" + this.domain + ", agentId='" + this.agentId + '\'' + ", ec2=" + this.ec2 + ", gcloud=" + this.gcloud + ", extraAgentData=" + this.extraAgentData + ", batchEnabled=" + this.batchEnabled + '}';
    }
}

