/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.amazonaws.util.EC2MetadataUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentEc2Metadata {
    private final Optional<String> instanceId;
    private final Optional<String> availabilityZone;
    private final Optional<String> subnetId;
    private final Optional<String> vpcId;
    private final Optional<String> privateIp;

    @JsonCreator
    public BaragonAgentEc2Metadata(@JsonProperty(value="instanceId") Optional<String> instanceId, @JsonProperty(value="availabilityZone") Optional<String> availabilityZone, @JsonProperty(value="subnetId") Optional<String> subnetId, @JsonProperty(value="vpcId") Optional<String> vpcId, @JsonProperty(value="privateIp") Optional<String> privateIp) {
        this.instanceId = instanceId;
        this.availabilityZone = availabilityZone;
        this.subnetId = subnetId;
        this.vpcId = vpcId;
        this.privateIp = privateIp;
    }

    public static BaragonAgentEc2Metadata fromEnvironment(Optional<String> privateipOverride, boolean skipPrivateIp) {
        return new BaragonAgentEc2Metadata(BaragonAgentEc2Metadata.findInstanceId(), BaragonAgentEc2Metadata.findAvailabilityZone(), BaragonAgentEc2Metadata.findSubnet(), BaragonAgentEc2Metadata.findVpc(), skipPrivateIp ? Optional.absent() : privateipOverride.or(BaragonAgentEc2Metadata.findPrivateIp()));
    }

    public static Optional<String> findInstanceId() {
        try {
            return Optional.fromNullable(EC2MetadataUtils.getInstanceId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public static Optional<String> findAvailabilityZone() {
        try {
            return Optional.fromNullable(EC2MetadataUtils.getAvailabilityZone());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private static Optional<String> findSubnet() {
        try {
            List<EC2MetadataUtils.NetworkInterface> networkInterfaces = EC2MetadataUtils.getNetworkInterfaces();
            if (EC2MetadataUtils.getNetworkInterfaces().isEmpty()) {
                return Optional.absent();
            }
            return Optional.fromNullable(networkInterfaces.get(0).getSubnetId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private static Optional<String> findPrivateIp() {
        try {
            return Optional.fromNullable(EC2MetadataUtils.getPrivateIpAddress());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private static Optional<String> findVpc() {
        try {
            Optional<String> maybeManuallySet = Optional.fromNullable(System.getenv("VPC_ID"));
            if (maybeManuallySet.isPresent()) {
                return maybeManuallySet;
            }
            List<EC2MetadataUtils.NetworkInterface> networkInterfaces = EC2MetadataUtils.getNetworkInterfaces();
            if (EC2MetadataUtils.getNetworkInterfaces().isEmpty()) {
                return Optional.absent();
            }
            return Optional.fromNullable(networkInterfaces.get(0).getVpcId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public Optional<String> getInstanceId() {
        return this.instanceId;
    }

    public Optional<String> getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Optional<String> getSubnetId() {
        return this.subnetId;
    }

    public Optional<String> getVpcId() {
        return this.vpcId;
    }

    public Optional<String> getPrivateIp() {
        return this.privateIp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaragonAgentEc2Metadata) {
            BaragonAgentEc2Metadata that = (BaragonAgentEc2Metadata)obj;
            return Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.availabilityZone, that.availabilityZone) && Objects.equals(this.subnetId, that.subnetId) && Objects.equals(this.vpcId, that.vpcId) && Objects.equals(this.privateIp, that.privateIp);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.availabilityZone, this.subnetId, this.vpcId, this.privateIp);
    }

    public String toString() {
        return "BaragonAgentEc2Metadata{instanceId=" + this.instanceId + ", availabilityZone=" + this.availabilityZone + ", subnetId=" + this.subnetId + ", vpcId=" + this.vpcId + ", privateIp=" + this.privateIp + '}';
    }
}

