/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.google.common.base.MoreObjects;

public class AgentResponseId {
    private final String id;
    private final int statusCode;
    private final boolean exception;
    private final int attempt;

    public static AgentResponseId fromString(String value) {
        String[] splits = value.split("\\-", 3);
        return new AgentResponseId(value, Integer.parseInt(splits[0]), Boolean.parseBoolean(splits[1]), Integer.parseInt(splits[2]));
    }

    private AgentResponseId(String id, int statusCode, boolean exception, int attempt) {
        this.id = id;
        this.statusCode = statusCode;
        this.exception = exception;
        this.attempt = attempt;
    }

    public String getId() {
        return this.id;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isException() {
        return this.exception;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public boolean isSuccess() {
        return !this.exception && this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentResponseId that = (AgentResponseId)o;
        if (this.attempt != that.attempt) {
            return false;
        }
        if (this.exception != that.exception) {
            return false;
        }
        if (this.statusCode != that.statusCode) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.statusCode;
        result = 31 * result + (this.exception ? 1 : 0);
        result = 31 * result + this.attempt;
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statusCode", this.statusCode).add("exception", this.exception).add("attempt", this.attempt).toString();
    }
}

