/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.hubspot.deploy.Artifact;
import com.hubspot.deploy.ArtifactList;
import com.hubspot.deploy.EmbeddedArtifact;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.deploy.ExternalArtifact;
import com.hubspot.deploy.RemoteArtifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.deploy.S3ArtifactSignature;
import com.hubspot.singularity.SingularityTaskExecutorData;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.models.DockerContext;
import com.hubspot.singularity.executor.models.EnvironmentContext;
import com.hubspot.singularity.executor.models.RunnerContext;
import com.hubspot.singularity.executor.task.SingularityExecutorArtifactFetcher;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.utils.DockerUtils;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.runner.base.shared.ProcessFailedException;
import com.spotify.docker.client.exceptions.DockerException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.mesos.Protos;

public class SingularityExecutorTaskProcessBuilder
implements Callable<ProcessBuilder> {
    private final SingularityExecutorTask task;
    private final TemplateManager templateManager;
    private final SingularityExecutorConfiguration configuration;
    private final String executorPid;
    private final ExecutorUtils executorUtils;
    private final SingularityTaskExecutorData executorData;
    private final SingularityExecutorArtifactFetcher artifactFetcher;
    private Optional<SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher> taskArtifactFetcher;
    private DockerUtils dockerUtils;
    private final ObjectMapper objectMapper;

    public SingularityExecutorTaskProcessBuilder(SingularityExecutorTask task, ExecutorUtils executorUtils, SingularityExecutorArtifactFetcher artifactFetcher, TemplateManager templateManager, SingularityExecutorConfiguration configuration, SingularityTaskExecutorData executorData, String executorPid, DockerUtils dockerUtils, ObjectMapper objectMapper) {
        this.executorData = executorData;
        this.objectMapper = objectMapper;
        this.task = task;
        this.executorUtils = executorUtils;
        this.artifactFetcher = artifactFetcher;
        this.templateManager = templateManager;
        this.configuration = configuration;
        this.executorPid = executorPid;
        this.taskArtifactFetcher = Optional.absent();
        this.dockerUtils = dockerUtils;
    }

    @Override
    public ProcessBuilder call() throws Exception {
        if (this.task.getTaskInfo().hasContainer() && this.task.getTaskInfo().getContainer().hasDocker()) {
            this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo().getTaskId(), Protos.TaskState.TASK_STARTING, String.format("Pulling image... (executor pid: %s)", this.executorPid), this.task.getLog());
            try {
                this.dockerUtils.pull(this.task.getTaskInfo().getContainer().getDocker().getImage());
            }
            catch (DockerException e) {
                throw new ProcessFailedException("Could not pull docker image", (Throwable)e);
            }
        }
        this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo().getTaskId(), Protos.TaskState.TASK_STARTING, String.format("Staging files... (executor pid: %s)", this.executorPid), this.task.getLog());
        this.taskArtifactFetcher = Optional.of((Object)this.artifactFetcher.buildTaskFetcher((ExecutorData)this.executorData, this.task));
        ((SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher)this.taskArtifactFetcher.get()).fetchFiles(this.executorData.getEmbeddedArtifacts(), this.executorData.getS3Artifacts(), this.executorData.getS3ArtifactSignaturesOrEmpty(), this.executorData.getExternalArtifacts());
        this.task.getArtifactVerifier().checkSignatures(this.executorData.getS3ArtifactSignaturesOrEmpty());
        ArrayList<ArtifactList> artifactLists = new ArrayList<ArtifactList>();
        artifactLists.addAll(this.checkArtifactsForArtifactLists(this.executorData.getS3Artifacts()));
        artifactLists.addAll(this.checkArtifactsForArtifactLists(this.executorData.getS3ArtifactSignaturesOrEmpty()));
        artifactLists.addAll(this.checkArtifactsForArtifactLists(this.executorData.getExternalArtifacts()));
        if (!artifactLists.isEmpty()) {
            ArrayList<EmbeddedArtifact> embeddedArtifacts = new ArrayList<EmbeddedArtifact>();
            ArrayList<S3Artifact> s3Artifacts = new ArrayList<S3Artifact>();
            ArrayList<S3ArtifactSignature> s3ArtifactSignatures = new ArrayList<S3ArtifactSignature>();
            ArrayList<ExternalArtifact> externalArtifacts = new ArrayList<ExternalArtifact>();
            for (ArtifactList artifactList : artifactLists) {
                embeddedArtifacts.addAll(artifactList.getEmbeddedArtifacts());
                s3Artifacts.addAll(artifactList.getS3Artifacts());
                s3ArtifactSignatures.addAll(artifactList.getS3ArtifactSignatures());
                externalArtifacts.addAll(artifactList.getExternalArtifacts());
            }
            this.task.getLog().info("Found {} artifact lists with {} embedded, {} s3, {} external, fetching...", new Object[]{artifactLists.size(), embeddedArtifacts.size(), s3Artifacts.size() + s3ArtifactSignatures.size(), externalArtifacts.size()});
            ((SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher)this.taskArtifactFetcher.get()).fetchFiles(embeddedArtifacts, s3Artifacts, s3ArtifactSignatures, externalArtifacts);
            this.task.getArtifactVerifier().checkSignatures(s3ArtifactSignatures);
        }
        ProcessBuilder processBuilder = this.buildProcessBuilder(this.task.getTaskInfo(), this.executorData, this.task.getTaskDefinition().getServiceLogFileName());
        this.task.getTaskLogManager().setup();
        return processBuilder;
    }

    private List<ArtifactList> checkArtifactsForArtifactLists(List<? extends RemoteArtifact> remoteArtifacts) {
        ArrayList<ArtifactList> artifactLists = new ArrayList<ArtifactList>();
        for (RemoteArtifact remoteArtifact : remoteArtifacts) {
            if (!remoteArtifact.isArtifactList()) continue;
            Path pathToArtifact = this.task.getArtifactPath((Artifact)remoteArtifact, this.task.getTaskDefinition().getTaskDirectoryPath()).resolve(remoteArtifact.getFilename());
            if (!Files.exists(pathToArtifact, new LinkOption[0])) {
                throw new IllegalStateException(String.format("Couldn't find artifact at %s - %s", pathToArtifact, remoteArtifact));
            }
            try {
                artifactLists.add((ArtifactList)this.objectMapper.readValue(pathToArtifact.toFile(), ArtifactList.class));
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't read artifacts from " + pathToArtifact, e);
            }
        }
        return artifactLists;
    }

    public void cancel() {
        if (this.taskArtifactFetcher.isPresent()) {
            ((SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher)this.taskArtifactFetcher.get()).cancel();
        }
    }

    private Path getPath(String filename) {
        return this.task.getTaskDefinition().getTaskDirectoryPath().resolve(filename);
    }

    private String getCommand(ExecutorData executorData) {
        StringBuilder bldr = new StringBuilder(Strings.isNullOrEmpty((String)executorData.getCmd()) ? "" : executorData.getCmd());
        for (String extraCmdLineArg : executorData.getExtraCmdLineArgs()) {
            bldr.append(" ");
            bldr.append(extraCmdLineArg);
        }
        return bldr.toString();
    }

    private String getExecutorUser() {
        return System.getProperty("user.name");
    }

    private ProcessBuilder buildProcessBuilder(Protos.TaskInfo taskInfo, SingularityTaskExecutorData executorData, String serviceLog) {
        String cmd = this.getCommand((ExecutorData)executorData);
        RunnerContext runnerContext = new RunnerContext(cmd, this.configuration.getTaskAppDirectory(), this.configuration.getLogrotateToDirectory(), (String)executorData.getUser().or((Object)this.configuration.getDefaultRunAsUser()), serviceLog, this.serviceLogOutPath(serviceLog), this.task.getTaskId(), (Optional<Integer>)executorData.getMaxTaskThreads().or(this.configuration.getMaxTaskThreads()), !this.getExecutorUser().equals(executorData.getUser().or((Object)this.configuration.getDefaultRunAsUser())), (Integer)executorData.getMaxOpenFiles().orNull(), String.format(this.configuration.getSwitchUserCommandFormat(), executorData.getUser().or((Object)this.configuration.getDefaultRunAsUser())), this.configuration.isUseFileAttributes(), this.getCfsQuota(executorData), this.configuration.getDefaultCfsPeriod());
        EnvironmentContext environmentContext = new EnvironmentContext(taskInfo);
        if (taskInfo.hasContainer() && taskInfo.getContainer().hasDocker()) {
            this.task.getLog().info("Writing a runner script to execute {} in docker container", (Object)cmd);
            this.templateManager.writeDockerScript(this.getPath("runner.sh"), new DockerContext(environmentContext, runnerContext, this.configuration.getDockerPrefix(), this.configuration.getDockerStopTimeout(), taskInfo.getContainer().getDocker().getPrivileged()));
        } else {
            this.templateManager.writeEnvironmentScript(this.getPath("deploy.env"), environmentContext);
            this.task.getLog().info("Writing a runner script to execute {} with {}", (Object)cmd, (Object)runnerContext);
            this.templateManager.writeRunnerScript(this.getPath("runner.sh"), runnerContext);
        }
        ArrayList command = Lists.newArrayList();
        command.add("bash");
        command.add("runner.sh");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(this.task.getTaskDefinition().getTaskDirectoryPath().toFile());
        processBuilder.redirectError(this.task.getTaskDefinition().getExecutorBashOutPath().toFile());
        processBuilder.redirectOutput(this.task.getTaskDefinition().getExecutorBashOutPath().toFile());
        return processBuilder;
    }

    private Integer getCfsQuota(SingularityTaskExecutorData executorData) {
        if (!executorData.getCpuHardLimit().isPresent()) {
            return null;
        }
        return (Integer)executorData.getCpuHardLimit().get() * this.configuration.getDefaultCfsPeriod();
    }

    private String serviceLogOutPath(String serviceLog) {
        Path basePath = this.task.getTaskDefinition().getTaskDirectoryPath();
        Path app = basePath.resolve(this.configuration.getTaskAppDirectory()).normalize();
        return app.relativize(basePath).resolve(serviceLog).toString();
    }

    public String toString() {
        return "SingularityExecutorTaskProcessBuilder [task=" + this.task.getTaskId() + "]";
    }
}

