/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.base.Throwables;
import com.hubspot.deploy.S3ArtifactSignature;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SingularityExecutorArtifactVerifier {
    private final Logger log;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final SingularityS3Configuration s3Configuration;
    private final SingularityExecutorTaskDefinition taskDefinition;

    public SingularityExecutorArtifactVerifier(SingularityExecutorTaskDefinition taskDefinition, Logger log, SingularityExecutorConfiguration executorConfiguration, SingularityS3Configuration s3Configuration) {
        this.log = log;
        this.executorConfiguration = executorConfiguration;
        this.s3Configuration = s3Configuration;
        this.taskDefinition = taskDefinition;
    }

    public void checkSignatures(List<S3ArtifactSignature> s3ArtifactsWithSignatures) {
        if (s3ArtifactsWithSignatures.isEmpty()) {
            this.log.info("No files containing artifact signatures specified, skipping verification.");
            return;
        }
        for (S3ArtifactSignature s3ArtifactSignature : s3ArtifactsWithSignatures) {
            this.checkArtifactSignature(s3ArtifactSignature);
        }
    }

    private void checkArtifactSignature(S3ArtifactSignature s3ArtifactSignature) {
        Path artifactPath = Paths.get(this.s3Configuration.getArtifactCacheDirectory(), s3ArtifactSignature.getArtifactFilename());
        Path artifactSignaturePath = Paths.get(this.s3Configuration.getArtifactCacheDirectory(), s3ArtifactSignature.getFilename());
        if (!Files.exists(artifactPath, new LinkOption[0])) {
            this.log.warn("Artifact {} not found for signature {}", (Object)artifactPath, (Object)s3ArtifactSignature);
            return;
        }
        ArrayList<String> verifyCommand = new ArrayList<String>(this.executorConfiguration.getArtifactSignatureVerificationCommand().size());
        for (String arg : this.executorConfiguration.getArtifactSignatureVerificationCommand()) {
            verifyCommand.add(arg.replace("{artifactPath}", artifactPath.toString()).replace("{artifactSignaturePath}", artifactSignaturePath.toString()));
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(verifyCommand);
            processBuilder.directory(this.taskDefinition.getTaskDirectoryPath().toFile());
            processBuilder.redirectError(this.taskDefinition.getSignatureVerifyOutPath().toFile());
            processBuilder.redirectOutput(this.taskDefinition.getSignatureVerifyOutPath().toFile());
            Process p = processBuilder.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                this.log.error("Failed to validate signature in file {} for artifact file {}", (Object)s3ArtifactSignature.getFilename(), (Object)s3ArtifactSignature.getArtifactFilename());
                if (this.executorConfiguration.isFailTaskOnInvalidArtifactSignature()) {
                    throw new RuntimeException(String.format("Failed to validate signature for artifact %s", artifactPath));
                }
            } else {
                this.log.info("Signature in {} for artifact {} is valid!", (Object)s3ArtifactSignature.getFilename(), (Object)s3ArtifactSignature.getArtifactFilename());
            }
        }
        catch (IOException | InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

