/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import java.nio.file.Paths;

public class LogrotateCronTemplateContext {
    private final String cronSchedule;
    private final String logrotateCommand;
    private final String logrotateStateFile;
    private final String logrotateConfig;

    public LogrotateCronTemplateContext(SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition, SingularityExecutorLogrotateFrequency logrotateFrequency) {
        this.logrotateCommand = configuration.getLogrotateCommand();
        this.logrotateStateFile = taskDefinition.getLogrotateStateFilePath().toString();
        this.logrotateConfig = Paths.get(configuration.getLogrotateConfDirectory(), new String[0]).resolve(taskDefinition.getTaskId()).toString();
        this.cronSchedule = (String)logrotateFrequency.getCronSchedule().get();
    }

    public String getLogrotateCommand() {
        return this.logrotateCommand;
    }

    public String getLogrotateStateFile() {
        return this.logrotateStateFile;
    }

    public String getLogrotateConfig() {
        return this.logrotateConfig;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }
}

