/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hubspot.singularity.InvalidSingularityTaskIdException;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.runner.base.config.SingularityRunnerBaseLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SingularityExecutorLogging {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorLogging.class);
    private final SingularityRunnerBaseLogging baseLogging;

    @Inject
    public SingularityExecutorLogging(SingularityRunnerBaseLogging baseLogging) {
        this.baseLogging = baseLogging;
    }

    public ch.qos.logback.classic.Logger buildTaskLogger(String taskId, String executorId, String executorPid, String taskLogFile) {
        LOG.info("Building a task logger for {} pointing to {}", (Object)taskId, (Object)taskLogFile);
        LoggerContext context = new LoggerContext();
        context.setName(executorPid);
        this.baseLogging.prepareRootLogger(context);
        String loggerId = taskId;
        try {
            SingularityTaskId singularityTaskId = SingularityTaskId.valueOf((String)taskId);
            loggerId = String.format("%s.%s.%s.%s.%s", singularityTaskId.getRequestId(), singularityTaskId.getDeployId(), singularityTaskId.getStartedAt(), singularityTaskId.getInstanceNo(), executorId);
        }
        catch (InvalidSingularityTaskIdException e) {
            LOG.info("Handling non-SingularityTaskId %s", (Object)taskId);
        }
        ch.qos.logback.classic.Logger taskLogger = context.getLogger(loggerId);
        taskLogger.detachAndStopAllAppenders();
        if (this.baseLogging.getRootLogPath().isPresent()) {
            taskLogger.addAppender((Appender)this.baseLogging.buildFileAppender(context, (String)this.baseLogging.getRootLogPath().get()));
        }
        taskLogger.addAppender((Appender)this.baseLogging.buildFileAppender(context, taskLogFile));
        context.start();
        return taskLogger;
    }

    public void stopTaskLogger(String taskId, ch.qos.logback.classic.Logger logger) {
        LOG.info("Stopping task logger for {}", (Object)taskId);
        try {
            logger.info("Task finished, stopping logger");
            logger.detachAndStopAllAppenders();
            logger.getLoggerContext().stop();
        }
        catch (Throwable t) {
            LOG.error("While closing task logger for {}", (Object)taskId, (Object)t);
        }
    }
}

