/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import java.net.IDN;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.Email;

public class EmailValidator
implements ConstraintValidator<Email, CharSequence> {
    private static final String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static final String DOMAIN = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*";
    private static final String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private static final int MAX_LOCAL_PART_LENGTH = 64;
    private static final int MAX_DOMAIN_PART_LENGTH = 255;
    private final Pattern localPattern = Pattern.compile("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*", 2);
    private final Pattern domainPattern = Pattern.compile("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]", 2);

    @Override
    public void initialize(Email annotation) {
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.length() == 0) {
            return true;
        }
        String[] emailParts = value.toString().split("@", 3);
        if (emailParts.length != 2) {
            return false;
        }
        if (emailParts[0].endsWith(".") || emailParts[1].endsWith(".")) {
            return false;
        }
        if (!this.matchPart(emailParts[0], this.localPattern, 64)) {
            return false;
        }
        return this.matchPart(emailParts[1], this.domainPattern, 255);
    }

    private boolean matchPart(String part, Pattern pattern, int maxLength) {
        String asciiString;
        try {
            asciiString = this.toAscii(part);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (asciiString.length() > maxLength) {
            return false;
        }
        Matcher matcher = pattern.matcher(asciiString);
        return matcher.matches();
    }

    private String toAscii(String unicodeString) throws IllegalArgumentException {
        String asciiString = "";
        int start = 0;
        int end = unicodeString.length() <= 63 ? unicodeString.length() : 63;
        while (true) {
            asciiString = asciiString + IDN.toASCII(unicodeString.substring(start, end));
            if (end == unicodeString.length()) break;
            start = end;
            end = start + 63 > unicodeString.length() ? unicodeString.length() : start + 63;
        }
        return asciiString;
    }
}

