/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos;

public class MesosNativeLibrary {
    public static final String VERSION = "1.1.2";
    private static Version version = null;
    private static boolean loaded = false;

    public static synchronized void load(String path) {
        if (loaded) {
            return;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MesosNativeLibrary.class.getClassLoader());
        try {
            if (path != null) {
                System.load(path);
            } else {
                System.loadLibrary("mesos");
            }
        }
        catch (UnsatisfiedLinkError error) {
            System.err.println("Failed to load native Mesos library from " + (path != null ? path : System.getProperty("java.library.path")));
            throw error;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static void load() {
        String path = System.getenv("MESOS_NATIVE_JAVA_LIBRARY");
        if (path == null && (path = System.getenv("MESOS_NATIVE_LIBRARY")) != null) {
            System.out.println("Warning: MESOS_NATIVE_LIBRARY is deprecated, use MESOS_NATIVE_JAVA_LIBRARY instead. Future releases will not support JNI bindings via MESOS_NATIVE_LIBRARY.");
        }
        MesosNativeLibrary.load(path);
    }

    public static synchronized Version version() {
        if (!loaded) {
            throw new RuntimeException("'libmesos' not loaded");
        }
        if (version == null) {
            try {
                version = MesosNativeLibrary._version();
            }
            catch (UnsatisfiedLinkError error) {
                System.err.println("WARNING: using an old version of 'libmesos' without proper version information: " + error.getMessage());
                version = new Version(0L, 0L, 0L);
            }
        }
        return version;
    }

    private static native Version _version();

    public static class Version
    implements Comparable<Version> {
        public final long major;
        public final long minor;
        public final long patch;

        public Version(long major, long minor, long patch) {
            if (major < 0L) {
                throw new IllegalArgumentException("Major version must not be negative");
            }
            if (minor < 0L) {
                throw new IllegalArgumentException("Minor version must not be negative");
            }
            if (patch < 0L) {
                throw new IllegalArgumentException("Patch version must not be negative");
            }
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public Version(long major, long minor) {
            this(major, minor, 0L);
        }

        public Version(long major) {
            this(major, 0L, 0L);
        }

        public boolean equals(Version other) {
            return other != null && this.major == other.major && this.minor == other.minor && this.patch == other.patch;
        }

        @Override
        public int compareTo(Version other) {
            if (other == null) {
                throw new IllegalArgumentException("other Version must not be null");
            }
            if (this.major < other.major) {
                return -1;
            }
            if (this.major > other.major) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            if (this.patch < other.patch) {
                return -1;
            }
            if (this.patch > other.patch) {
                return 1;
            }
            return 0;
        }

        public boolean before(Version other) {
            return this.compareTo(other) < 0;
        }

        public boolean after(Version other) {
            return this.compareTo(other) > 0;
        }
    }
}

