/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.marshaller.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.DeflaterOutputStream;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.marshaller.Marshaller;
import net.kencochrane.raven.marshaller.json.InterfaceBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMarshaller
implements Marshaller {
    public static final String EVENT_ID = "event_id";
    public static final String MESSAGE = "message";
    public static final String TIMESTAMP = "timestamp";
    public static final String LEVEL = "level";
    public static final String LOGGER = "logger";
    public static final String PLATFORM = "platform";
    public static final String CULPRIT = "culprit";
    public static final String TAGS = "tags";
    public static final String SERVER_NAME = "server_name";
    public static final String MODULES = "modules";
    public static final String EXTRA = "extra";
    public static final String CHECKSUM = "checksum";
    public static final int MAX_MESSAGE_LENGTH = 1000;
    private static final ThreadLocal<DateFormat> ISO_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JsonMarshaller.class);
    private final JsonFactory jsonFactory = new JsonFactory();
    private final Map<Class<? extends SentryInterface>, InterfaceBinding<?>> interfaceBindings = new HashMap();
    private boolean compression = true;

    @Override
    public void marshall(Event event, OutputStream destination) {
        destination = new Marshaller.UncloseableOutputStream(destination);
        if (this.compression) {
            destination = new DeflaterOutputStream(BaseEncoding.base64().encodingStream(new OutputStreamWriter(destination, Charsets.UTF_8)));
        }
        try (JsonGenerator generator = this.jsonFactory.createGenerator(destination);){
            this.writeContent(generator, event);
        }
        catch (IOException e) {
            logger.error("An exception occurred while serialising the event.", e);
        }
    }

    private void writeContent(JsonGenerator generator, Event event) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(EVENT_ID, this.formatId(event.getId()));
        generator.writeStringField(MESSAGE, this.formatMessage(event.getMessage()));
        generator.writeStringField(TIMESTAMP, ISO_FORMAT.get().format(event.getTimestamp()));
        generator.writeStringField(LEVEL, this.formatLevel(event.getLevel()));
        generator.writeStringField(LOGGER, event.getLogger());
        generator.writeStringField(PLATFORM, event.getPlatform());
        generator.writeStringField(CULPRIT, event.getCulprit());
        this.writeTags(generator, event.getTags());
        generator.writeStringField(SERVER_NAME, event.getServerName());
        this.writeExtras(generator, event.getExtra());
        generator.writeStringField(CHECKSUM, event.getChecksum());
        this.writeInterfaces(generator, event.getSentryInterfaces());
        generator.writeEndObject();
    }

    private void writeInterfaces(JsonGenerator generator, Map<String, SentryInterface> sentryInterfaces) throws IOException {
        for (Map.Entry<String, SentryInterface> interfaceEntry : sentryInterfaces.entrySet()) {
            SentryInterface sentryInterface = interfaceEntry.getValue();
            if (this.interfaceBindings.containsKey(sentryInterface.getClass())) {
                generator.writeFieldName(interfaceEntry.getKey());
                this.getInterfaceBinding(sentryInterface).writeInterface(generator, interfaceEntry.getValue());
                continue;
            }
            logger.error("Couldn't parse the content of '{}' provided in {}.", (Object)interfaceEntry.getKey(), (Object)sentryInterface);
        }
    }

    private <T extends SentryInterface> InterfaceBinding<? super T> getInterfaceBinding(T sentryInterface) {
        return this.interfaceBindings.get(sentryInterface.getClass());
    }

    private void writeExtras(JsonGenerator generator, Map<String, Object> extras) throws IOException {
        generator.writeObjectFieldStart(EXTRA);
        for (Map.Entry<String, Object> extra : extras.entrySet()) {
            generator.writeFieldName(extra.getKey());
            this.safelyWriteObject(generator, extra.getValue());
        }
        generator.writeEndObject();
    }

    private void safelyWriteObject(JsonGenerator generator, Object value) throws IOException {
        if (value != null && value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Iterable) {
            generator.writeStartArray();
            for (Object subValue : (Iterable)value) {
                this.safelyWriteObject(generator, subValue);
            }
            generator.writeEndArray();
        } else if (value instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)((Object)value)).entrySet()) {
                if (entry.getKey() == null) {
                    generator.writeFieldName("null");
                } else {
                    generator.writeFieldName(entry.getKey().toString());
                }
                this.safelyWriteObject(generator, entry.getValue());
            }
            generator.writeEndObject();
        } else if (value == null) {
            generator.writeNull();
        } else {
            try {
                generator.writeObject(value);
            }
            catch (IllegalStateException e) {
                logger.debug("Couldn't marshal '{}' of type '{}', had to be converted into a String", (Object)value, (Object)value.getClass());
                generator.writeString(value.toString());
            }
        }
    }

    private void writeTags(JsonGenerator generator, Map<String, String> tags) throws IOException {
        generator.writeObjectFieldStart(TAGS);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            generator.writeStringField(tag.getKey(), tag.getValue());
        }
        generator.writeEndObject();
    }

    private String formatMessage(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() > 1000) {
            return message.substring(0, 1000);
        }
        return message;
    }

    private String formatId(UUID id) {
        return id.toString().replaceAll("-", "");
    }

    private String formatLevel(Event.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case DEBUG: {
                return "debug";
            }
            case FATAL: {
                return "fatal";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
        }
        logger.error("The level '{}' isn't supported, this should NEVER happen, contact Raven developers", (Object)level.name());
        return null;
    }

    public <T extends SentryInterface, F extends T> void addInterfaceBinding(Class<F> sentryInterfaceClass, InterfaceBinding<T> binding) {
        this.interfaceBindings.put(sentryInterfaceClass, binding);
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }
}

