/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.dsn;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JndiLookup {
    private static final String JNDI_DSN_NAME = "java:comp/env/sentry/dsn";
    private static final Logger logger = LoggerFactory.getLogger(JndiLookup.class);

    private JndiLookup() {
    }

    public static String jndiLookup() {
        String dsn = null;
        try {
            InitialContext c = new InitialContext();
            dsn = (String)c.lookup(JNDI_DSN_NAME);
        }
        catch (NoInitialContextException e) {
            logger.debug("JNDI not configured for sentry (NoInitialContextEx)");
        }
        catch (NamingException e) {
            logger.debug("No /sentry/dsn in JNDI");
        }
        catch (RuntimeException e) {
            logger.warn("Odd RuntimeException while testing for JNDI", e);
        }
        return dsn;
    }

    public String toString() {
        return "JndiLookup{JNDI_DSN_NAME='java:comp/env/sentry/dsn'}";
    }
}

