/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.connection;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.kencochrane.raven.connection.Connection;
import net.kencochrane.raven.environment.RavenEnvironment;
import net.kencochrane.raven.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(AsyncConnection.class);
    private static final long SHUTDOWN_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private final Connection actualConnection;
    private final ExecutorService executorService;
    private final ShutDownHook shutDownHook = new ShutDownHook();
    private boolean closed;

    public AsyncConnection(Connection actualConnection, ExecutorService executorService, boolean gracefulShutdown) {
        this.actualConnection = actualConnection;
        this.executorService = executorService == null ? Executors.newSingleThreadExecutor() : executorService;
        if (gracefulShutdown) {
            this.addShutdownHook();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    @Override
    public void send(Event event) {
        if (!this.closed) {
            this.executorService.execute(new EventSubmitter(event));
        }
    }

    @Override
    public void close() throws IOException {
        Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
        this.doClose();
    }

    private void doClose() throws IOException {
        logger.info("Gracefully shutdown sentry threads.");
        this.closed = true;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown took too much time, forcing the shutdown.");
                List<Runnable> tasks = this.executorService.shutdownNow();
                logger.info("{} tasks failed to execute before the shutdown.", (Object)tasks.size());
            }
            logger.info("Shutdown finished.");
        }
        catch (InterruptedException e) {
            logger.error("Graceful shutdown interrupted, forcing the shutdown.");
            List<Runnable> tasks = this.executorService.shutdownNow();
            logger.info("{} tasks failed to execute before the shutdown.", (Object)tasks.size());
        }
        finally {
            this.actualConnection.close();
        }
    }

    private final class ShutDownHook
    extends Thread {
        private ShutDownHook() {
        }

        @Override
        public void run() {
            RavenEnvironment.startManagingThread();
            try {
                logger.info("Automatic shutdown of the async connection");
                AsyncConnection.this.doClose();
            }
            catch (Exception e) {
                logger.error("An exception occurred while closing the connection.", e);
            }
            finally {
                RavenEnvironment.stopManagingThread();
            }
        }
    }

    private final class EventSubmitter
    implements Runnable {
        private final Event event;

        private EventSubmitter(Event event) {
            this.event = event;
        }

        @Override
        public void run() {
            RavenEnvironment.startManagingThread();
            try {
                AsyncConnection.this.actualConnection.send(this.event);
            }
            catch (Exception e) {
                logger.error("An exception occurred while sending the event to Sentry.", e);
            }
            finally {
                RavenEnvironment.stopManagingThread();
            }
        }
    }
}

