/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.google.common.collect.ImmutableList;
import io.dropwizard.jackson.Discoverable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverableSubtypeResolver
extends StdSubtypeResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoverableSubtypeResolver.class);
    private final ImmutableList<Class<?>> discoveredSubtypes;

    public DiscoverableSubtypeResolver() {
        this(Discoverable.class);
    }

    public DiscoverableSubtypeResolver(Class<?> rootKlass) {
        ImmutableList.Builder subtypes = ImmutableList.builder();
        for (Class<?> klass : this.discoverServices(rootKlass)) {
            for (Class<?> subtype : this.discoverServices(klass)) {
                subtypes.add(subtype);
                this.registerSubtypes(subtype);
            }
        }
        this.discoveredSubtypes = subtypes.build();
    }

    public ImmutableList<Class<?>> getDiscoveredSubtypes() {
        return this.discoveredSubtypes;
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected List<Class<?>> discoverServices(Class<?> klass) {
        ArrayList serviceClasses = new ArrayList();
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources("META-INF/services/" + klass.getName());
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream input = url.openStream();
                Throwable throwable = null;
                try {
                    InputStreamReader streamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(streamReader);
                        Throwable throwable3 = null;
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                Class<?> loadedClass = this.loadClass(line);
                                if (loadedClass == null) continue;
                                serviceClasses.add(loadedClass);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (streamReader == null) continue;
                        if (throwable2 != null) {
                            try {
                                streamReader.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        streamReader.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    input.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load META-INF/services/{}", (Object)klass.getName(), (Object)e);
        }
        return serviceClasses;
    }

    @Nullable
    private Class<?> loadClass(String line) {
        try {
            return this.getClassLoader().loadClass(line.trim());
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Unable to load {}", (Object)line);
            return null;
        }
    }
}

