/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.jackson.UnixTimestampDeserializer;
import com.spotify.docker.client.jackson.UnixTimestampSerializer;
import com.spotify.docker.client.messages.AutoValue_Event;
import com.spotify.docker.client.messages.AutoValue_Event_Actor;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Event {
    @Deprecated
    @Nullable
    @JsonProperty(value="status")
    public abstract String status();

    @Deprecated
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @Deprecated
    @Nullable
    @JsonProperty(value="from")
    public abstract String from();

    @Nullable
    @JsonProperty(value="Type")
    public abstract Type type();

    @Nullable
    @JsonProperty(value="Action")
    public abstract String action();

    @Nullable
    @JsonProperty(value="Actor")
    public abstract Actor actor();

    @JsonProperty(value="time")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    @JsonSerialize(using=UnixTimestampSerializer.class)
    public abstract Date time();

    @Nullable
    @JsonProperty(value="timeNano")
    public abstract Long timeNano();

    @JsonCreator
    static Event create(@JsonProperty(value="status") String status, @JsonProperty(value="id") String id, @JsonProperty(value="from") String from, @JsonProperty(value="Type") Type type, @JsonProperty(value="Action") String action, @JsonProperty(value="Actor") Actor actor, @JsonProperty(value="time") Date time, @JsonProperty(value="timeNano") Long timeNano) {
        return new AutoValue_Event(status, id, from, type, action, actor, time, timeNano);
    }

    public static enum Type {
        CONTAINER("container"),
        IMAGE("image"),
        VOLUME("volume"),
        NETWORK("network"),
        DAEMON("daemon");

        private final String name;

        @JsonCreator
        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }

    public static abstract class Actor {
        @JsonProperty(value="ID")
        public abstract String id();

        @Nullable
        @JsonProperty(value="Attributes")
        public abstract ImmutableMap<String, String> attributes();

        @JsonCreator
        static Actor create(@JsonProperty(value="ID") String id, @JsonProperty(value="Attributes") Map<String, String> attributes) {
            ImmutableMap<String, String> attributesT = attributes == null ? null : ImmutableMap.copyOf(attributes);
            return new AutoValue_Event_Actor(id, attributesT);
        }
    }
}

