/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AutoValue_Container;
import com.spotify.docker.client.messages.AutoValue_Container_PortMapping;
import com.spotify.docker.client.messages.ContainerMount;
import com.spotify.docker.client.messages.NetworkSettings;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Container {
    @JsonProperty(value="Id")
    public abstract String id();

    @Nullable
    @JsonProperty(value="Names")
    public abstract ImmutableList<String> names();

    @JsonProperty(value="Image")
    public abstract String image();

    @Nullable
    @JsonProperty(value="ImageID")
    public abstract String imageId();

    @JsonProperty(value="Command")
    public abstract String command();

    @JsonProperty(value="Created")
    public abstract Long created();

    @Nullable
    @JsonProperty(value="State")
    public abstract String state();

    @JsonProperty(value="Status")
    public abstract String status();

    @Nullable
    @JsonProperty(value="Ports")
    public abstract ImmutableList<PortMapping> ports();

    @Nullable
    @JsonProperty(value="Labels")
    public abstract ImmutableMap<String, String> labels();

    @Nullable
    @JsonProperty(value="SizeRw")
    public abstract Long sizeRw();

    @Nullable
    @JsonProperty(value="SizeRootFs")
    public abstract Long sizeRootFs();

    @Nullable
    @JsonProperty(value="NetworkSettings")
    public abstract NetworkSettings networkSettings();

    @Nullable
    @JsonProperty(value="Mounts")
    public abstract ImmutableList<ContainerMount> mounts();

    public String portsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.ports() != null) {
            for (PortMapping port : this.ports()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (port.ip() != null) {
                    sb.append(port.ip()).append(":");
                }
                if (port.publicPort() > 0) {
                    sb.append(port.privatePort()).append("->").append(port.publicPort());
                } else {
                    sb.append(port.privatePort());
                }
                sb.append("/").append(port.type());
            }
        }
        return sb.toString();
    }

    @JsonCreator
    static Container create(@JsonProperty(value="Id") String id, @JsonProperty(value="Names") List<String> names, @JsonProperty(value="Image") String image, @JsonProperty(value="ImageID") String imageId, @JsonProperty(value="Command") String command, @JsonProperty(value="Created") Long created, @JsonProperty(value="State") String state, @JsonProperty(value="Status") String status, @JsonProperty(value="Ports") List<PortMapping> ports, @JsonProperty(value="Labels") Map<String, String> labels, @JsonProperty(value="SizeRw") Long sizeRw, @JsonProperty(value="SizeRootFs") Long sizeRootFs, @JsonProperty(value="NetworkSettings") NetworkSettings networkSettings, @JsonProperty(value="Mounts") List<ContainerMount> mounts) {
        ImmutableMap<String, String> labelsT = labels == null ? null : ImmutableMap.copyOf(labels);
        ImmutableList<ContainerMount> mountsT = mounts == null ? null : ImmutableList.copyOf(mounts);
        ImmutableList<String> namesT = names == null ? null : ImmutableList.copyOf(names);
        ImmutableList<PortMapping> portsT = ports == null ? null : ImmutableList.copyOf(ports);
        return new AutoValue_Container(id, namesT, image, imageId, command, created, state, status, portsT, labelsT, sizeRw, sizeRootFs, networkSettings, mountsT);
    }

    public static abstract class PortMapping {
        @JsonProperty(value="PrivatePort")
        public abstract Integer privatePort();

        @JsonProperty(value="PublicPort")
        public abstract Integer publicPort();

        @JsonProperty(value="Type")
        public abstract String type();

        @Nullable
        @JsonProperty(value="IP")
        public abstract String ip();

        @JsonCreator
        static PortMapping create(@JsonProperty(value="PrivatePort") int privatePort, @JsonProperty(value="PublicPort") int publicPort, @JsonProperty(value="Type") String type, @JsonProperty(value="IP") String ip) {
            return new AutoValue_Container_PortMapping(privatePort, publicPort, type, ip);
        }
    }
}

