/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.ApacheUnixSocket;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import jnr.unixsocket.UnixSocketAddress;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class UnixConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public UnixConnectionSocketFactory(URI socketUri) {
        String filename = socketUri.toString().replaceAll("^unix:///", "unix://localhost/").replaceAll("^unix://localhost", "");
        this.socketFile = new File(filename);
    }

    public static URI sanitizeUri(URI uri) {
        if (uri.getScheme().equals("unix")) {
            return URI.create("unix://localhost:80");
        }
        return uri;
    }

    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        return new ApacheUnixSocket();
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        try {
            socket.connect(new UnixSocketAddress(this.socketFile), connectTimeout);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectTimeoutException(e, null, remoteAddress.getAddress());
        }
        return socket;
    }
}

