/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.s3.base;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.runner.base.sentry.SingularityRunnerExceptionNotifier;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;

public class S3ArtifactChunkDownloader
implements Callable<Path> {
    private final SingularityS3Configuration configuration;
    private final AmazonS3 s3;
    private final S3Artifact s3Artifact;
    private final Path downloadTo;
    private final int chunk;
    private final long chunkSize;
    private final long length;
    private final Logger log;
    private final SingularityRunnerExceptionNotifier exceptionNotifier;
    private int retryNum;

    public S3ArtifactChunkDownloader(SingularityS3Configuration configuration, Logger log, AmazonS3 s3, S3Artifact s3Artifact, Path downloadTo, int chunk, long chunkSize, long length, SingularityRunnerExceptionNotifier exceptionNotifier) {
        this.configuration = configuration;
        this.log = log;
        this.s3 = s3;
        this.s3Artifact = s3Artifact;
        this.downloadTo = downloadTo;
        this.chunk = chunk;
        this.chunkSize = chunkSize;
        this.length = length;
        this.exceptionNotifier = exceptionNotifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path call() throws Exception {
        long start = System.currentTimeMillis();
        ExecutorService chunkExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("S3ArtifactDownloaderChunk-" + this.chunk + "-Thread-%d").build());
        try {
            while ((long)this.retryNum <= this.configuration.getS3ChunkRetries()) {
                long timeout = System.currentTimeMillis();
                Future<Path> future = chunkExecutorService.submit(this.createDownloader(this.retryNum));
                try {
                    Path path = future.get(this.configuration.getS3ChunkDownloadTimeoutMillis(), TimeUnit.MILLISECONDS);
                    return path;
                }
                catch (TimeoutException te) {
                    block10: {
                        this.log.error("Chunk {} (retry {}) for {} timed out after {} - total duration {}", this.chunk, this.retryNum, this.s3Artifact.getFilename(), JavaUtils.duration(timeout), JavaUtils.duration(start));
                        future.cancel(true);
                        if ((long)this.retryNum == this.configuration.getS3ChunkRetries()) {
                            this.exceptionNotifier.notify("Timeout downloading chunk", te, ImmutableMap.of("filename", this.s3Artifact.getFilename(), "chunk", Integer.toString(this.chunk), "retry", Integer.toString(this.retryNum)));
                        }
                        break block10;
                        catch (InterruptedException ie) {
                            this.log.warn("Chunk {} (retry {}) for {} interrupted", this.chunk, this.retryNum, this.s3Artifact.getFilename());
                            this.exceptionNotifier.notify("Interrupted during download", ie, ImmutableMap.of("filename", this.s3Artifact.getFilename(), "chunk", Integer.toString(this.chunk), "retry", Integer.toString(this.retryNum)));
                            break block10;
                        }
                        catch (Throwable t) {
                            this.log.error("Error while downloading chunk {} (retry {}) for {}", this.chunk, this.retryNum, this.s3Artifact.getFilename(), t);
                            this.exceptionNotifier.notify(String.format("Error downloading chunk (%s)", t.getMessage()), t, ImmutableMap.of("filename", this.s3Artifact.getFilename(), "chunk", Integer.toString(this.chunk), "retry", Integer.toString(this.retryNum)));
                        }
                    }
                    ++this.retryNum;
                }
            }
            throw new IllegalStateException(String.format("Chunk %s for %s failed to download after %s tries", this.chunk, this.s3Artifact.getFilename(), this.retryNum + 1));
        }
        finally {
            chunkExecutorService.shutdownNow();
        }
    }

    private Callable<Path> createDownloader(final int retryNum) {
        return new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                Path chunkPath = S3ArtifactChunkDownloader.this.chunk == 0 ? S3ArtifactChunkDownloader.this.downloadTo : Paths.get(S3ArtifactChunkDownloader.this.downloadTo + "_" + S3ArtifactChunkDownloader.this.chunk + "_" + retryNum, new String[0]);
                chunkPath.toFile().deleteOnExit();
                long startTime = System.currentTimeMillis();
                long byteRangeStart = (long)S3ArtifactChunkDownloader.this.chunk * S3ArtifactChunkDownloader.this.chunkSize;
                long byteRangeEnd = Math.min((long)(S3ArtifactChunkDownloader.this.chunk + 1) * S3ArtifactChunkDownloader.this.chunkSize - 1L, S3ArtifactChunkDownloader.this.length);
                S3ArtifactChunkDownloader.this.log.info("Downloading {} - chunk {} (retry {}) ({}-{}) to {}", S3ArtifactChunkDownloader.this.s3Artifact.getFilename(), S3ArtifactChunkDownloader.this.chunk, retryNum, byteRangeStart, byteRangeEnd, chunkPath);
                GetObjectRequest getObjectRequest = new GetObjectRequest(S3ArtifactChunkDownloader.this.s3Artifact.getS3Bucket(), S3ArtifactChunkDownloader.this.s3Artifact.getS3ObjectKey()).withRange(byteRangeStart, byteRangeEnd);
                S3Object fetchedObject = S3ArtifactChunkDownloader.this.s3.getObject(getObjectRequest);
                try (S3ObjectInputStream is = fetchedObject.getObjectContent();){
                    Files.copy(is, chunkPath, StandardCopyOption.REPLACE_EXISTING);
                }
                S3ArtifactChunkDownloader.this.log.info("Finished downloading chunk {} (retry {}) of {} ({} bytes) in {}", S3ArtifactChunkDownloader.this.chunk, retryNum, S3ArtifactChunkDownloader.this.s3Artifact.getFilename(), byteRangeEnd - byteRangeStart, JavaUtils.duration(startTime));
                return chunkPath;
            }
        };
    }
}

