/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.s3.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.hubspot.deploy.S3Artifact;
import java.util.Objects;

public class ArtifactDownloadRequest {
    private final String targetDirectory;
    private final S3Artifact s3Artifact;
    private final Optional<Long> timeoutMillis;

    @JsonCreator
    public ArtifactDownloadRequest(@JsonProperty(value="targetDirectory") String targetDirectory, @JsonProperty(value="s3Artifact") S3Artifact s3Artifact, @JsonProperty(value="timeoutMillis") Optional<Long> timeoutMillis) {
        Preconditions.checkNotNull(targetDirectory);
        Preconditions.checkNotNull(s3Artifact);
        this.targetDirectory = targetDirectory;
        this.s3Artifact = s3Artifact;
        this.timeoutMillis = timeoutMillis;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public S3Artifact getS3Artifact() {
        return this.s3Artifact;
    }

    public Optional<Long> getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public int hashCode() {
        return Objects.hash(this.targetDirectory, this.s3Artifact);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactDownloadRequest that = (ArtifactDownloadRequest)o;
        return Objects.equals(this.s3Artifact, that.s3Artifact) && Objects.equals(this.targetDirectory, that.targetDirectory);
    }

    public String toString() {
        return "ArtifactDownloadRequest [targetDirectory=" + this.targetDirectory + ", s3Artifact=" + this.s3Artifact + ", timeoutMillis=" + this.timeoutMillis + "]";
    }
}

