/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class TailMetadata {
    private final String filename;
    private final String tag;
    private final Map<String, String> extraFields;
    private final boolean finished;
    private final String filenameKey;

    public static Path getTailMetadataPath(Path logMetadataDirectory, String logMetadataSuffix, TailMetadata tail) {
        return logMetadataDirectory.resolve(Paths.get(tail.getFilenameKey() + logMetadataSuffix, new String[0]));
    }

    @JsonCreator
    public TailMetadata(@JsonProperty(value="filename") String filename, @JsonProperty(value="tag") String tag, @JsonProperty(value="extraFields") Map<String, String> extraFields, @JsonProperty(value="finished") boolean finished) {
        this.filename = filename;
        this.tag = tag;
        this.extraFields = extraFields;
        this.finished = finished;
        this.filenameKey = this.generateFilenameKey(filename);
    }

    private String generateFilenameKey(String filename) {
        return Hashing.sha256().hashString(filename, StandardCharsets.UTF_8).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TailMetadata other = (TailMetadata)obj;
        return !(this.filename == null ? other.filename != null : !this.filename.equals(other.filename));
    }

    @JsonIgnore
    public String getFilenameKey() {
        return this.filenameKey;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getTag() {
        return this.tag;
    }

    public Map<String, String> getExtraFields() {
        return this.extraFields;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String toString() {
        return "TailMetadata [filename=" + this.filename + ", tag=" + this.tag + ", extraFields=" + this.extraFields + ", finished=" + this.finished + ", filenameKey=" + this.filenameKey + "]";
    }
}

