/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.shared;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.hubspot.singularity.runner.base.shared.ProcessFailedException;
import com.hubspot.singularity.runner.base.shared.SafeProcessManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class SimpleProcessManager
extends SafeProcessManager {
    public SimpleProcessManager(Logger log) {
        super(log);
    }

    public void runCommand(List<String> command, Set<Integer> acceptableExitCodes) throws InterruptedException, ProcessFailedException {
        this.runCommand(command, ProcessBuilder.Redirect.INHERIT, acceptableExitCodes);
    }

    public void runCommand(List<String> command) throws InterruptedException, ProcessFailedException {
        this.runCommand(command, ProcessBuilder.Redirect.INHERIT, Sets.newHashSet(0));
    }

    public List<String> runCommandWithOutput(List<String> command, Set<Integer> acceptableExitCodes) throws InterruptedException, ProcessFailedException {
        return this.runCommand(command, ProcessBuilder.Redirect.PIPE, acceptableExitCodes);
    }

    public List<String> runCommandWithOutput(List<String> command) throws InterruptedException, ProcessFailedException {
        return this.runCommand(command, ProcessBuilder.Redirect.PIPE, Sets.newHashSet(0));
    }

    public List<String> runCommand(List<String> command, ProcessBuilder.Redirect redirectOutput) throws InterruptedException, ProcessFailedException {
        return this.runCommand(command, redirectOutput, Sets.newHashSet(0));
    }

    public List<String> runCommand(List<String> command, ProcessBuilder.Redirect redirectOutput, Set<Integer> acceptableExitCodes) throws InterruptedException, ProcessFailedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Optional<Integer> exitCode = Optional.absent();
        Optional<Object> reader = Optional.absent();
        String processToString = this.getCurrentProcessToString();
        try {
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectOutput(redirectOutput);
            Process process = this.startProcess(processBuilder);
            processToString = this.getCurrentProcessToString();
            if (redirectOutput == ProcessBuilder.Redirect.PIPE) {
                reader = Optional.of(new OutputReader(process.getInputStream()));
                ((OutputReader)reader.get()).start();
            }
            exitCode = Optional.of(process.waitFor());
            if (reader.isPresent()) {
                ((OutputReader)reader.get()).join();
                if (((OutputReader)reader.get()).error.isPresent()) {
                    throw (Throwable)((OutputReader)reader.get()).error.get();
                }
            }
        }
        catch (InterruptedException ie) {
            this.signalKillToProcessIfActive();
            throw ie;
        }
        catch (Throwable t) {
            this.getLog().error("Unexpected exception while running {}", (Object)processToString, (Object)t);
            this.signalKillToProcessIfActive();
            throw Throwables.propagate(t);
        }
        finally {
            this.processFinished(exitCode);
        }
        if (exitCode.isPresent() && !acceptableExitCodes.contains(exitCode.get())) {
            throw new ProcessFailedException(String.format("Got unacceptable exit code %s while running %s", exitCode, processToString));
        }
        if (!reader.isPresent()) {
            return Collections.emptyList();
        }
        return ((OutputReader)reader.get()).output;
    }

    private static class OutputReader
    extends Thread {
        private final List<String> output = new ArrayList<String>();
        private final InputStream inputStream;
        private Optional<Throwable> error;

        public OutputReader(InputStream inputStream) {
            this.inputStream = inputStream;
            this.error = Optional.absent();
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));){
                String line = br.readLine();
                while (line != null) {
                    this.output.add(line);
                    line = br.readLine();
                }
            }
            catch (Throwable t) {
                this.error = Optional.of(t);
            }
        }
    }
}

