/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.shared;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.hubspot.mesos.JavaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.slf4j.Logger;

public class JsonObjectFileHelper {
    private final ObjectMapper objectMapper;

    @Inject
    public JsonObjectFileHelper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> Optional<T> read(Path file, Logger log, Class<T> clazz) throws IOException {
        long start = System.currentTimeMillis();
        log.info("Reading {}", (Object)file);
        byte[] bytes = new byte[]{};
        try {
            bytes = Files.readAllBytes(file);
            log.trace("Read {} bytes from {} in {}", bytes.length, file, JavaUtils.duration(start));
            if (bytes.length == 0) {
                return Optional.absent();
            }
            T object = this.objectMapper.readValue(bytes, clazz);
            return Optional.of(object);
        }
        catch (NoSuchFileException nsfe) {
            log.warn("File {} does not exist", (Object)file);
        }
        catch (IOException e) {
            log.warn("File {} is not a valid {} ({})", file, clazz.getSimpleName(), new String(bytes, StandardCharsets.UTF_8), e);
        }
        return Optional.absent();
    }

    public InputStream toInputStream(Map<String, Object> input) throws IOException {
        return new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeObject(Object object, Path path, Logger log) {
        long start = System.currentTimeMillis();
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(object);
            log.info("Writing {} bytes of {} to {}", bytes.length, object, path);
            Files.write(path, bytes, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            log.error("Failed writing {}", object, (Object)t);
            boolean bl = false;
            return bl;
        }
        finally {
            log.trace("Finishing writing {} after {}", object, (Object)JavaUtils.duration(start));
        }
    }
}

