/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.hubspot.singularity.runner.base.configuration.BaseRunnerConfiguration;
import com.hubspot.singularity.runner.base.configuration.Configuration;
import io.dropwizard.configuration.ConfigurationValidationException;
import java.io.File;
import java.util.Set;
import javax.validation.Validator;

public class SingularityRunnerConfigurationProvider<T extends BaseRunnerConfiguration>
implements Provider<T> {
    private final Class<T> clazz;
    private final Optional<String> filename;
    @Inject
    @Named(value="yaml")
    private ObjectMapper objectMapper;
    @Inject
    private Validator validator;

    public SingularityRunnerConfigurationProvider(Class<T> clazz, Optional<String> filename) {
        this.clazz = clazz;
        this.filename = filename;
    }

    private JsonNode loadYamlField(String filename, String field) {
        File yamlFile = new File(filename);
        if (!yamlFile.exists()) {
            return this.objectMapper.createObjectNode();
        }
        try {
            JsonNode baseTree = this.objectMapper.readTree(yamlFile);
            return baseTree.hasNonNull(field) ? baseTree.get(field) : this.objectMapper.createObjectNode();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public T get() {
        Configuration configuration = this.clazz.getAnnotation(Configuration.class);
        try {
            File baseFile = new File(configuration.filename());
            BaseRunnerConfiguration baseConfig = baseFile.exists() ? (BaseRunnerConfiguration)this.objectMapper.readValue(baseFile, this.clazz) : (BaseRunnerConfiguration)this.clazz.newInstance();
            ObjectNode overrideNode = this.filename.isPresent() ? this.loadYamlField(this.filename.get(), configuration.consolidatedField()) : this.objectMapper.createObjectNode();
            BaseRunnerConfiguration config = (BaseRunnerConfiguration)this.objectMapper.readerForUpdating(baseConfig).readValue(overrideNode);
            Set violations = this.validator.validate(config, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConfigurationValidationException(this.filename.or(configuration.filename()), violations);
            }
            return (T)config;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

