/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.hubspot.deploy.Artifact;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorArtifactFetcher;
import com.hubspot.singularity.executor.task.SingularityExecutorArtifactVerifier;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskCleanup;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskLogManager;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskProcessBuilder;
import com.hubspot.singularity.executor.utils.DockerUtils;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.executor.utils.MesosUtils;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.shared.JsonObjectFileHelper;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.v1.Protos;
import org.slf4j.Logger;

public class SingularityExecutorTask {
    private final ExecutorDriver driver;
    private final Protos.TaskInfo taskInfo;
    private final ch.qos.logback.classic.Logger log;
    private final ReentrantLock lock;
    private final AtomicBoolean killed;
    private final AtomicInteger threadCountAtOverage;
    private final AtomicBoolean killedAfterThreadOverage;
    private final AtomicBoolean destroyedAfterWaiting;
    private final AtomicBoolean forceDestroyed;
    private final AtomicReference<Optional<String>> killedBy;
    private final SingularityExecutorTaskProcessBuilder processBuilder;
    private final SingularityExecutorTaskLogManager taskLogManager;
    private final SingularityExecutorTaskCleanup taskCleanup;
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorArtifactVerifier artifactVerifier;

    public SingularityExecutorTask(ExecutorDriver driver, ExecutorUtils executorUtils, SingularityRunnerBaseConfiguration baseConfiguration, SingularityExecutorConfiguration executorConfiguration, SingularityExecutorTaskDefinition taskDefinition, String executorPid, SingularityExecutorArtifactFetcher artifactFetcher, Protos.TaskInfo taskInfo, TemplateManager templateManager, ch.qos.logback.classic.Logger log, JsonObjectFileHelper jsonObjectFileHelper, DockerUtils dockerUtils, SingularityS3Configuration s3Configuration, ObjectMapper objectMapper) {
        this.driver = driver;
        this.taskInfo = taskInfo;
        this.log = log;
        this.lock = new ReentrantLock();
        this.killed = new AtomicBoolean(false);
        this.destroyedAfterWaiting = new AtomicBoolean(false);
        this.forceDestroyed = new AtomicBoolean(false);
        this.killedBy = new AtomicReference(Optional.absent());
        this.killedAfterThreadOverage = new AtomicBoolean(false);
        this.threadCountAtOverage = new AtomicInteger(0);
        this.taskDefinition = taskDefinition;
        this.taskLogManager = new SingularityExecutorTaskLogManager(taskDefinition, templateManager, baseConfiguration, executorConfiguration, log, jsonObjectFileHelper);
        this.taskCleanup = new SingularityExecutorTaskCleanup(this.taskLogManager, executorConfiguration, taskDefinition, log, dockerUtils);
        this.processBuilder = new SingularityExecutorTaskProcessBuilder(this, executorUtils, artifactFetcher, templateManager, executorConfiguration, taskDefinition.getExecutorData(), executorPid, dockerUtils, objectMapper);
        this.artifactVerifier = new SingularityExecutorArtifactVerifier(taskDefinition, log, executorConfiguration, s3Configuration);
    }

    public void cleanup(Protos.TaskState state) {
        ExtendedTaskState extendedTaskState = MesosUtils.fromTaskState(Protos.TaskState.valueOf(state.toString()));
        boolean cleanupAppTaskDirectory = !extendedTaskState.isFailed() && this.taskDefinition.getExecutorData().getPreserveTaskSandboxAfterFinish().or(Boolean.FALSE) == false;
        boolean isDocker = this.taskInfo.hasContainer() && this.taskInfo.getContainer().hasDocker();
        this.taskCleanup.cleanup(cleanupAppTaskDirectory, isDocker);
    }

    public Path getArtifactPath(Artifact artifact, Path defaultPath) {
        if (artifact.getTargetFolderRelativeToTask().isPresent()) {
            Path relativePath = Paths.get(artifact.getTargetFolderRelativeToTask().get(), new String[0]);
            if (!relativePath.isAbsolute()) {
                return this.getTaskDefinition().getTaskDirectoryPath().resolve(relativePath);
            }
            this.getLog().warn("Absolute targetFolderRelativeToTask {} ignored for artifact {}", (Object)relativePath, (Object)artifact);
        }
        return defaultPath;
    }

    public SingularityExecutorTaskLogManager getTaskLogManager() {
        return this.taskLogManager;
    }

    public boolean isSuccessExitCode(int exitCode) {
        if (this.getExecutorData().getSuccessfulExitCodes().isEmpty()) {
            return exitCode == 0;
        }
        return this.getExecutorData().getSuccessfulExitCodes().contains(exitCode);
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public ch.qos.logback.classic.Logger getLogbackLog() {
        return this.log;
    }

    public Logger getLog() {
        return this.log;
    }

    public SingularityExecutorTaskProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public boolean wasForceDestroyed() {
        return this.forceDestroyed.get();
    }

    public boolean wasDestroyedAfterWaiting() {
        return this.destroyedAfterWaiting.get();
    }

    public boolean wasKilled() {
        return this.killed.get();
    }

    public void markKilled(Optional<String> maybeUser) {
        this.killed.set(true);
        this.killedBy.set(maybeUser);
    }

    public void markKilledDueToThreads(int currentThreads) {
        this.killedAfterThreadOverage.set(true);
        this.threadCountAtOverage.set(currentThreads);
    }

    public boolean wasKilledDueToThreads() {
        return this.killedAfterThreadOverage.get();
    }

    public int getThreadCountAtOverageTime() {
        return this.threadCountAtOverage.get();
    }

    public void markForceDestroyed(Optional<String> maybeUser) {
        this.forceDestroyed.set(true);
        this.killedBy.set(maybeUser);
    }

    public Optional<String> getKilledBy() {
        return this.killedBy.get();
    }

    public void markDestroyedAfterWaiting() {
        this.destroyedAfterWaiting.set(true);
    }

    public ExecutorDriver getDriver() {
        return this.driver;
    }

    public Protos.TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public String getTaskId() {
        return this.taskDefinition.getTaskId();
    }

    public ExecutorData getExecutorData() {
        return this.taskDefinition.getExecutorData();
    }

    public SingularityExecutorTaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public SingularityExecutorArtifactVerifier getArtifactVerifier() {
        return this.artifactVerifier;
    }

    public String toString() {
        return "SingularityExecutorTask [taskInfo=" + this.taskInfo + ", killed=" + this.killed + ", getTaskId()=" + this.getTaskId() + "]";
    }
}

