/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.mesos.Protos;

public class EnvironmentContext {
    private final Protos.TaskInfo taskInfo;

    public EnvironmentContext(Protos.TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public List<Protos.Environment.Variable> getEnv() {
        return this.taskInfo.getExecutor().getCommand().getEnvironment().getVariablesList();
    }

    public Protos.ContainerInfo.DockerInfo getDockerInfo() {
        return this.taskInfo.getContainer().getDocker();
    }

    public List<String> getDockerParameters() {
        ArrayList<String> args = new ArrayList<String>();
        for (Protos.Parameter parameter : this.taskInfo.getContainer().getDocker().getParametersList()) {
            args.add(this.toCmdLineArg(parameter));
        }
        return args;
    }

    public boolean isDockerWorkdirOverriden() {
        for (Protos.Parameter parameter : this.taskInfo.getContainer().getDocker().getParametersList()) {
            if (!parameter.hasKey() || !parameter.getKey().equals("w") && !parameter.getKey().equals("workdir")) continue;
            return true;
        }
        return false;
    }

    public List<Protos.Volume> getContainerVolumes() {
        return this.taskInfo.getContainer().getVolumesList();
    }

    private String toCmdLineArg(Protos.Parameter parameter) {
        if (parameter.hasKey() && parameter.getKey().length() > 1) {
            if (parameter.hasValue() && !Strings.isNullOrEmpty(parameter.getValue())) {
                return String.format("--%s=%s", parameter.getKey(), parameter.getValue());
            }
            return String.format("--%s", parameter.getKey());
        }
        if (parameter.hasValue() && !Strings.isNullOrEmpty(parameter.getValue())) {
            return String.format("-%s=%s", parameter.getKey(), parameter.getValue());
        }
        return String.format("-%s", parameter.getKey());
    }

    public String toString() {
        return "EnvironmentContext{taskInfo=" + this.taskInfo + '}';
    }
}

