/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;

public class SingularityExecutorCleanupStatistics {
    private final int totalTaskFiles;
    private final int ioErrorTasks;
    private final int runningTasksIgnored;
    private final int mesosRunningTasks;
    private final int successfullyCleanedTasks;
    private final int errorTasks;
    private final int waitingTasks;
    private final int invalidTasks;
    private final Optional<String> errorMessage;

    @JsonCreator
    public SingularityExecutorCleanupStatistics(@JsonProperty(value="totalTaskFiles") int totalTaskFiles, @JsonProperty(value="mesosRunningTasks") int mesosRunningTasks, @JsonProperty(value="waitingTasks") int waitingTasks, @JsonProperty(value="runningTasksIgnored") int runningTasksIgnored, @JsonProperty(value="successfullyCleanedTasks") int successfullyCleanedTasks, @JsonProperty(value="ioErrorTasks") int ioErrorTasks, @JsonProperty(value="errorTasks") int errorTasks, @JsonProperty(value="invalidTasks") int invalidTasks, @JsonProperty(value="errorMessage") Optional<String> errorMessage) {
        this.errorMessage = errorMessage;
        this.totalTaskFiles = totalTaskFiles;
        this.mesosRunningTasks = mesosRunningTasks;
        this.runningTasksIgnored = runningTasksIgnored;
        this.ioErrorTasks = ioErrorTasks;
        this.successfullyCleanedTasks = successfullyCleanedTasks;
        this.errorTasks = errorTasks;
        this.invalidTasks = invalidTasks;
        this.waitingTasks = waitingTasks;
    }

    public int getWaitingTasks() {
        return this.waitingTasks;
    }

    public int getRunningTasksIgnored() {
        return this.runningTasksIgnored;
    }

    public int getIoErrorTasks() {
        return this.ioErrorTasks;
    }

    public int getTotalTaskFiles() {
        return this.totalTaskFiles;
    }

    public int getMesosRunningTasks() {
        return this.mesosRunningTasks;
    }

    public int getSuccessfullyCleanedTasks() {
        return this.successfullyCleanedTasks;
    }

    public int getErrorTasks() {
        return this.errorTasks;
    }

    public int getInvalidTasks() {
        return this.invalidTasks;
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "SingularityExecutorCleanupStatistics [totalTaskFiles=" + this.totalTaskFiles + ", ioErrorTasks=" + this.ioErrorTasks + ", runningTasksIgnored=" + this.runningTasksIgnored + ", mesosRunningTasks=" + this.mesosRunningTasks + ", successfullyCleanedTasks=" + this.successfullyCleanedTasks + ", errorTasks=" + this.errorTasks + ", waitingTasks=" + this.waitingTasks + ", invalidTasks=" + this.invalidTasks + ", errorMessage=" + this.errorMessage + "]";
    }

    public static class SingularityExecutorCleanupStatisticsBuilder {
        private int totalTaskFiles;
        private int runningTasksIgnored;
        private int mesosRunningTasks;
        private int waitingTasks;
        private int successfullyCleanedTasks;
        private int ioErrorTasks;
        private int errorTasks;
        private int invalidTasks;
        private String errorMessage;

        public void incrTotalTaskFiles() {
            ++this.totalTaskFiles;
        }

        public void incrRunningTasksIgnored() {
            ++this.runningTasksIgnored;
        }

        public void incrIoErrorTasks() {
            ++this.ioErrorTasks;
        }

        public void incrWaitingTasks() {
            ++this.waitingTasks;
        }

        public void setMesosRunningTasks(int mesosRunningTasks) {
            this.mesosRunningTasks = mesosRunningTasks;
        }

        public void incrErrorTasks() {
            ++this.errorTasks;
        }

        public void incrSuccessfullyCleanedTasks() {
            ++this.successfullyCleanedTasks;
        }

        public void incrInvalidTasks() {
            ++this.invalidTasks;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public SingularityExecutorCleanupStatistics build() {
            return new SingularityExecutorCleanupStatistics(this.totalTaskFiles, this.mesosRunningTasks, this.waitingTasks, this.runningTasksIgnored, this.successfullyCleanedTasks, this.ioErrorTasks, this.errorTasks, this.invalidTasks, Optional.fromNullable(this.errorMessage));
        }
    }
}

