/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.google.inject.Inject;
import com.hubspot.singularity.executor.SingularityExecutorMesosFrameworkMessageHandler;
import com.hubspot.singularity.executor.SingularityExecutorMonitor;
import com.hubspot.singularity.executor.config.SingularityExecutorTaskBuilder;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.executor.utils.MesosUtils;
import org.apache.mesos.Executor;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutor
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutor.class);
    private final SingularityExecutorTaskBuilder taskBuilder;
    private final SingularityExecutorMesosFrameworkMessageHandler messageHandler;
    private final SingularityExecutorMonitor monitor;
    private final ExecutorUtils executorUtils;

    @Inject
    public SingularityExecutor(SingularityExecutorMonitor monitor, ExecutorUtils executorUtils, SingularityExecutorTaskBuilder taskBuilder, SingularityExecutorMesosFrameworkMessageHandler messageHandler) {
        this.taskBuilder = taskBuilder;
        this.monitor = monitor;
        this.executorUtils = executorUtils;
        this.messageHandler = messageHandler;
    }

    @Override
    public void registered(ExecutorDriver executorDriver, Protos.ExecutorInfo executorInfo, Protos.FrameworkInfo frameworkInfo, Protos.SlaveInfo slaveInfo) {
        LOG.debug("Registered {} with Mesos slave {} for framework {}", executorInfo.getExecutorId().getValue(), slaveInfo.getId().getValue(), frameworkInfo.getId().getValue());
        LOG.trace("Registered {} with Mesos slave {} for framework {}", MesosUtils.formatForLogging(executorInfo), MesosUtils.formatForLogging(slaveInfo), MesosUtils.formatForLogging(frameworkInfo));
    }

    @Override
    public void reregistered(ExecutorDriver executorDriver, Protos.SlaveInfo slaveInfo) {
        LOG.debug("Re-registered with Mesos slave {}", (Object)slaveInfo.getId().getValue());
        LOG.info("Re-registered with Mesos slave {}", (Object)MesosUtils.formatForLogging(slaveInfo));
    }

    @Override
    public void disconnected(ExecutorDriver executorDriver) {
        LOG.warn("Disconnected from Mesos slave");
    }

    @Override
    public void launchTask(ExecutorDriver executorDriver, Protos.TaskInfo taskInfo) {
        String taskId = taskInfo.getTaskId().getValue();
        LOG.info("Asked to launch task {}", (Object)taskId);
        try {
            ch.qos.logback.classic.Logger taskLog = this.taskBuilder.buildTaskLogger(taskId, taskInfo.getExecutor().getExecutorId().getValue());
            SingularityExecutorTask task = this.taskBuilder.buildTask(taskId, executorDriver, taskInfo, taskLog);
            SingularityExecutorMonitor.SubmitState submitState = this.monitor.submit(task);
            switch (submitState) {
                case REJECTED: {
                    LOG.warn("Can't launch task {}, it was rejected (probably due to shutdown)", (Object)taskInfo);
                    break;
                }
                case TASK_ALREADY_EXISTED: {
                    LOG.error("Can't launch task {}, already had a task with that ID", (Object)taskInfo);
                    break;
                }
                case SUBMITTED: {
                    task.getLog().info("Launched task {} with data {}", (Object)taskId, (Object)task.getExecutorData());
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception starting task {}", (Object)taskId, (Object)t);
            this.executorUtils.sendStatusUpdate(executorDriver, taskInfo.getTaskId(), Protos.TaskState.TASK_LOST, String.format("Unexpected exception while launching task %s - %s", taskId, t.getMessage()), LOG);
        }
    }

    @Override
    public void killTask(ExecutorDriver executorDriver, Protos.TaskID taskID) {
        String taskId = taskID.getValue();
        LOG.info("Asked to kill task {}", (Object)taskId);
        SingularityExecutorMonitor.KillState killState = this.monitor.requestKill(taskId);
        switch (killState) {
            case DIDNT_EXIST: 
            case INCONSISTENT_STATE: {
                LOG.warn("Couldn't kill task {} due to killState {}", (Object)taskId, (Object)killState);
                break;
            }
            case DESTROYING_PROCESS: 
            case INTERRUPTING_PRE_PROCESS: 
            case KILLING_PROCESS: {
                LOG.info("Requested kill of task {} with killState {}", (Object)taskId, (Object)killState);
            }
        }
    }

    @Override
    public void frameworkMessage(ExecutorDriver executorDriver, byte[] bytes) {
        try {
            this.messageHandler.handleMessage(bytes);
        }
        catch (Throwable t) {
            LOG.warn("Unexpected exception while handling framework message", t);
        }
    }

    @Override
    public void shutdown(ExecutorDriver executorDriver) {
        LOG.info("Asked to shutdown executor...");
        this.monitor.shutdown(executorDriver);
    }

    @Override
    public void error(ExecutorDriver executorDriver, String s) {
        LOG.error("Executor error: {}", (Object)s);
    }
}

