/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Settings related to deleting a request")
public class SingularityDeleteRequestRequest {
    private final Optional<String> message;
    private final Optional<String> actionId;
    private final Optional<Boolean> deleteFromLoadBalancer;

    @JsonCreator
    public SingularityDeleteRequestRequest(@JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="deleteFromLoadBalancer") Optional<Boolean> deleteFromLoadBalancer) {
        this.message = message;
        this.actionId = actionId;
        this.deleteFromLoadBalancer = deleteFromLoadBalancer;
    }

    @Schema(description="A message to show to users about why this action was taken", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(description="An id to associate with this action for metadata purposes", nullable=true)
    public Optional<String> getActionId() {
        return this.actionId;
    }

    @Schema(description="Should the service associated with the request be removed from the load balancer", nullable=true)
    public Optional<Boolean> getDeleteFromLoadBalancer() {
        return this.deleteFromLoadBalancer;
    }

    public String toString() {
        return "SingularityDeleteRequestRequest{message=" + this.message + ", actionId=" + this.actionId + ", deleteFromLoadBalancer=" + this.deleteFromLoadBalancer + '}';
    }
}

