/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityShellCommand;
import com.hubspot.singularity.api.SingularityBounceRequestBuilder;
import com.hubspot.singularity.api.SingularityExpiringRequestParent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;

@Schema(description="Settings for how a bounce will behave")
public class SingularityBounceRequest
extends SingularityExpiringRequestParent {
    private final Optional<Boolean> incremental;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<SingularityShellCommand> runShellCommandBeforeKill;

    @JsonCreator
    public SingularityBounceRequest(@JsonProperty(value="incremental") Optional<Boolean> incremental, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="durationMillis") Optional<Long> durationMillis, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="runShellCommandBeforeKill") Optional<SingularityShellCommand> runShellCommandBeforeKill) {
        super(durationMillis, actionId, message);
        this.incremental = incremental;
        this.skipHealthchecks = skipHealthchecks;
        this.runShellCommandBeforeKill = runShellCommandBeforeKill;
    }

    public static SingularityBounceRequest defaultRequest() {
        return new SingularityBounceRequest(Optional.absent(), Optional.absent(), Optional.absent(), Optional.of(UUID.randomUUID().toString()), Optional.absent(), Optional.absent());
    }

    public SingularityBounceRequestBuilder toBuilder() {
        return new SingularityBounceRequestBuilder().setIncremental(this.incremental).setSkipHealthchecks(this.skipHealthchecks).setDurationMillis(this.getDurationMillis()).setActionId(this.getActionId()).setMessage(this.getMessage()).setRunShellCommandBeforeKill(this.getRunShellCommandBeforeKill());
    }

    @Schema(description="If present and set to true, old tasks will be killed as soon as replacement tasks are available, instead of waiting for all replacement tasks to be healthy")
    public Optional<Boolean> getIncremental() {
        return this.incremental;
    }

    @Schema(description="Instruct replacement tasks for this bounce only to skip healthchecks")
    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    @Schema(description="Attempt to run this shell command on each task before it is shut down")
    public Optional<SingularityShellCommand> getRunShellCommandBeforeKill() {
        return this.runShellCommandBeforeKill;
    }

    @Override
    public String toString() {
        return "SingularityBounceRequest{incremental=" + this.incremental + ", skipHealthchecks=" + this.skipHealthchecks + ", runShellCommandBeforeKill=" + this.runShellCommandBeforeKill + "} " + super.toString();
    }
}

